%define upstreamname lxterminal
%define gtkver 3
Name: lxde-lxterminal
Version: 0.4.1
Release: alt2

Summary: Desktop-independent VTE-based terminal emulator for LXDE
License: GPL-2.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/lxde/lxterminal.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libgtk+%gtkver-devel docbook-dtds docbook-style-xsl xsltproc intltool desktop-file-utils pkgconfig(glib-2.0) pkgconfig(x11) ImageMagick-tools
BuildRequires: libpcre2-devel
%if %gtkver==3
BuildRequires: libvte3-devel
%else
BuildRequires: libvte-devel
%endif

%description
%summary  without any unnecessary dependency (All instances share the same
process to reduce memory usage).

%prep
%setup -n %name-%version
%autopatch -p1

%build
%autoreconf
%configure \
    --enable-man \
%if %gtkver==3
    --enable-gtk3
%endif

%make_build

%install
%makeinstall_std
%find_lang %upstreamname
desktop-file-install --dir %buildroot%_desktopdir \
    --remove-category=Utility \
    --add-category=System \
    %buildroot%_desktopdir/lxterminal.desktop

for x in 16 32 48; do
    mkdir -p %buildroot%_iconsdir/hicolor/$x'x'$x/apps
    convert %buildroot%_iconsdir/hicolor/128x128/apps/%upstreamname.png -resize $x'x'$x \
            %buildroot%_iconsdir/hicolor/$x'x'$x/apps/%upstreamname.png
done

%files -f %upstreamname.lang
%doc ChangeLog INSTALL README.md
%_bindir/*
%_desktopdir/*.desktop
%_datadir/%upstreamname
%_man1dir/*
%_iconsdir/hicolor/*/apps/%upstreamname.png

%changelog
