%define _unpackaged_files_terminate_build 1
%define origname lxpanel

Name: lxde-%origname
Version: 0.11.1
Release: alt1

Summary: LXPanel is a lightweight X11 desktop panel
License: GPL-2.0-or-later
Group: Graphical desktop/Other

Url: https://github.com/lxde/lxpanel
VCS: https://github.com/lxde/lxpanel.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

#Requires: lxde-freedesktop-menu
Requires: altlinux-freedesktop-menu-lxde
Requires: menu-cache

BuildPreReq: libfm-devel
BuildPreReq: rpm-build-xdg
BuildPreReq: libgtk+3-devel
BuildRequires: intltool
BuildRequires: libmenu-cache-devel
BuildRequires: libwireless-devel
BuildRequires: libcurl-devel
BuildRequires: pkgconfig(libwnck-3.0)
BuildRequires: pkgconfig(keybinder-3.0)
BuildRequires: pkgconfig(libxml-2.0)

%description
lxpanel is a program that provides a panel for desktop, usually LXDE.
It is lightweight GTK+ 3.x based desktop panel.

%package devel
Summary: development headers to build %name plugins
Group: System/Libraries
Requires: %name = %version

%description devel
This package provides files required to build plugins
for %name.

%prep
%setup -n %name-%version

%build
%autoreconf
%configure \
	--enable-man \
	--with-plugins=all \
	--enable-cast-checks \
	--enable-gtk3

%make_build

%install
%makeinstall_std
%find_lang %origname

%files -f %origname.lang
%doc AUTHORS ChangeLog README
%_bindir/*
%_xdgconfigdir/%origname
%_datadir/%origname
%_libdir/%origname
%_man1dir/*

%files devel
%_includedir/*
%_pkgconfigdir/*.pc

%changelog
