%define _unpackaged_files_terminate_build 1
%define theme_virt_dir lxde

%define theme_name upstream
#define theme_version 0.1

%define theme_fullname lxde-settings-%theme_name
%define gtkver 2
Name: lxde-common
Version: 0.99.2
Release: alt7.1
BuildArch: noarch

Summary: Basic infrastructure for LXDE.
License: %gpl2plus
Group: Graphical desktop/Other
Url: https://git.lxde.org/gitweb/?p=lxde/lxde-common.git
BuildArch: noarch

Source: %name-%version.tar
Source1: lxde.wm
Source2: panel
Patch: lxde-common-copy_skel_settings.patch
Patch1: lxde-common-XDG_DATA_DIRS.patch

AutoReq: yes,nosymlinks

Requires: lxde-settings
Requires: wm-common-freedesktop

BuildRequires: docbook-dtds xsltproc
 
BuildRequires: rpm-build-licenses intltool libgtk+%gtkver-devel

%description
Provides infrastructure for LXDE components

%package -n %theme_fullname
#Version: theme_version
Summary: provides unmodified LXDE configuration from upstream
Group: Graphical desktop/Other
Provides: lxde-settings

### GRRRR!!! for appliance-desktop-lxde
Provides: lxde-default-theme

Requires: lxde-icon-theme

%description -n %theme_fullname
Default graphics theme for LXDE.

This package contains unmodified configuration from upstream.

%prep
%setup
%patch -p1
%patch1 -p1

%build
sed -i 's,lxde.conf,LXDE.conf,' Makefile.am
%autoreconf
%configure --enable-man

%make_build

%install
%makeinstall_std

install -m644 -D %SOURCE1 %buildroot%_x11sysconfdir/wmsession.d/09LXDE

mkdir -p %buildroot%_datadir/%theme_fullname
mv %buildroot%_datadir/lxde/* %buildroot%_datadir/%theme_fullname
rmdir %buildroot%_datadir/lxde

mkdir -p %buildroot%_datadir/%theme_fullname/pcmanfm
mv %buildroot%_sysconfdir/xdg/pcmanfm/LXDE/pcmanfm.conf %buildroot%_datadir/%theme_fullname/pcmanfm/lxde.conf

mv %buildroot%_sysconfdir/xdg/lxsession/LXDE/desktop.conf %buildroot%_datadir/%theme_fullname

mkdir -p %buildroot%_datadir/%theme_fullname/openbox
mv %buildroot%_sysconfdir/xdg/openbox/LXDE/rc.xml %buildroot%_datadir/%theme_fullname/openbox/lxde-rc.xml
mv %buildroot%_sysconfdir/xdg/openbox/LXDE/menu.xml %buildroot%_datadir/%theme_fullname/openbox/menu.xml
rmdir %buildroot%_sysconfdir/xdg/openbox/LXDE

mkdir -p %buildroot%_datadir/%theme_fullname/lxpanel
mv %buildroot%_sysconfdir/xdg/lxpanel/LXDE/* %buildroot%_datadir/%theme_fullname/lxpanel
rmdir %buildroot%_sysconfdir/xdg/lxpanel/LXDE

ln -s %_datadir/%theme_virt_dir/desktop.conf %buildroot%_sysconfdir/xdg/lxsession/LXDE/desktop.conf
ln -s %_datadir/%theme_virt_dir/pcmanfm/lxde.conf %buildroot%_sysconfdir/xdg/pcmanfm/LXDE/pcmanfm.conf
ln -s %_datadir/%theme_virt_dir/pcmanfm/lxde.conf %buildroot%_sysconfdir/xdg/pcmanfm/LXDE/lxde.conf
ln -s %_datadir/%theme_virt_dir/lxpanel/ %buildroot%_sysconfdir/xdg/lxpanel/LXDE
ln -s %_datadir/%theme_virt_dir/openbox %buildroot%_sysconfdir/xdg/openbox/LXDE

mkdir -p %buildroot/etc/alternatives/packages.d/
cat > %buildroot/etc/alternatives/packages.d/%theme_fullname << __EOF__
%_datadir/%theme_virt_dir %_datadir/%theme_fullname 1
__EOF__

# Install desktop files
mkdir -p %buildroot%_desktopdir/
cp -v debian/*.desktop %buildroot%_desktopdir/

#Install panel config
install -m644 %SOURCE2 %buildroot%_datadir/%theme_fullname/lxpanel/panels/

%find_lang %name

%pre
if [ -d %_datadir/lxpanel/profile/LXDE ] && [ ! -L %_datadir/lxpanel/profile/LXDE ] ; then
 rm -fR %_datadir/lxpanel/profile/LXDE
fi
rm -fR %_sysconfdir/xdg/lxsession/LXDE/desktop.conf \
       %_sysconfdir/xdg/pcmanfm/LXDE \
       %_sysconfdir/xdg/lxpanel/LXDE \
       %_sysconfdir/xdg/openbox/LXDE

%files -f %name.lang
%doc ChangeLog INSTALL README
%_bindir/*
%_x11sysconfdir/wmsession.d/*
%_sysconfdir/xdg/*
%dir %_datadir/xsessions
%_datadir/xsessions/*.desktop
%_man1dir/*
%_desktopdir/*.desktop

%files -n %theme_fullname
%_sysconfdir/alternatives/packages.d/%theme_fullname
%_datadir/%theme_fullname

%changelog
