%define _unpackaged_files_terminate_build 1
%def_with check
%define luarocks_revision 1
%define abiversion 1

Name: lua5.4-module-luasocket
Version: 3.1.0
Release: alt2_lr%luarocks_revision
Epoch: 1

Summary: Network support for the Lua language
License: MIT
Group: Development/Other
Url: https://lunarmodules.github.io/luasocket/
Vcs: https://github.com/lunarmodules/luasocket

Source: luasocket-%version.tar
Patch1: lua-module-luasocket-3.0.0-alt-headers.patch

%if "5.4" >= "5.3"
Obsoletes: lua-module-luasocket < %EVR
Provides: lua-module-luasocket = %version
%else
Obsoletes: lua5-luasocket < %EVR
Provides: lua5-luasocket = %version
%endif

# self-dependencies
%filter_from_requires /lua5.4(dispatch)/d
%filter_from_requires /lua5.4(socket\..*)/d

BuildRequires(pre): rpm-macros-lua
BuildRequires: lua5.4-luarocks
BuildRequires: liblua5.4-devel

Provides: luarocks5.4(luasocket) = %EVR

%description
LuaSocket is a Lua extension library that is composed by two parts: a C
core that provides support for the TCP and UDP transport layers, and a
set of Lua modules that add support for functionality commonly needed
by applications that deal with the Internet.

%package devel
Summary: Headers for %name
Group: Development/Other
Requires: %name

%description devel
This package contains development files for %name.

%package -n liblua5.4-module-luasocket%abiversion
Summary: Shared libraries for %name
Group: Development/Other
Requires: %name

%description -n liblua5.4-module-luasocket%abiversion
Shared libraries for %name.

%prep
%setup -n luasocket-%version
%patch1 -p2

%build
luarocks-5.4 make --verbose --local --deps-mode all CFLAGS="%optflags" --pack-binary-rock \
    rockspecs/luasocket-%version-%luarocks_revision.rockspec

%install
luarocks-5.4 install *.rock --verbose --local --tree %buildroot%prefix --deps-mode none \
    --no-manifest

# install development files
install -d %buildroot%_includedir/luasocket
install -p -m 0644 src/*.h %buildroot%_includedir/luasocket

# rename shared libraries
mv %buildroot%lua_modulesdir/mime/core.so     %buildroot%lua_modulesdir/mime/core.so.%abiversion
mv %buildroot%lua_modulesdir/socket/core.so   %buildroot%lua_modulesdir/socket/core.so.%abiversion
mv %buildroot%lua_modulesdir/socket/serial.so %buildroot%lua_modulesdir/socket/serial.so.%abiversion
mv %buildroot%lua_modulesdir/socket/unix.so   %buildroot%lua_modulesdir/socket/unix.so.%abiversion
# create symlinks
ln -sr %buildroot%lua_modulesdir/mime/core.so.%abiversion       %buildroot%lua_modulesdir/mime/core.so
ln -sr %buildroot%lua_modulesdir/socket/core.so.%abiversion     %buildroot%lua_modulesdir/socket/core.so
ln -sr %buildroot%lua_modulesdir/socket/serial.so.%abiversion   %buildroot%lua_modulesdir/socket/serial.so
ln -sr %buildroot%lua_modulesdir/socket/unix.so.%abiversion     %buildroot%lua_modulesdir/socket/unix.so

%check
subst 's|bin/lua$|bin/lua5.4|' test/udp-zero-length-send*
%lua_path_add_buildroot
( lua5.4 test/testsrvr.lua ||: )&
sleep 1
lua5.4 test/testclnt.lua
lua5.4 test/hello.lua

%files
%doc LICENSE
%luarocks_dbdir/luasocket
%lua_modulesdir_noarch/*

%files devel
%_includedir/luasocket
%lua_modulesdir/mime/core.so
%lua_modulesdir/socket/core.so
%lua_modulesdir/socket/serial.so
%lua_modulesdir/socket/unix.so

%files -n liblua5.4-module-luasocket%abiversion
%lua_modulesdir/mime/core.so.%abiversion
%lua_modulesdir/socket/core.so.%abiversion
%lua_modulesdir/socket/serial.so.%abiversion
%lua_modulesdir/socket/unix.so.%abiversion

%changelog
