%define oname luasec

Name: lua5.4-module-%oname
Version: 1.2.0
Release: alt1
Summary: A binding for OpenSSL library to provide TLS/SSL communication over LuaSocket
License: MIT
Group: Development/Other
Url: https://github.com/brunoos/luasec/wiki

%if "5.4" >= "5.3"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%endif

Source: luasec-%version.tar

BuildRequires(pre): liblua5.4-devel lua5.4
BuildRequires: lua5.4-module-luasocket-devel libssl-devel

%description
This version delegates to LuaSocket the TCP connection establishment between
the client and server. Then LuaSec uses this connection to start a secure
TLS/SSL session.

%prep
%setup -n %oname-%version

%build
# regenerate OpenSSL options
pushd src
%lua options.lua -g /usr/include/openssl/ssl.h > options.c
popd

%make_build linux \
	CFLAGS="%optflags -DWITH_LUASOCKET -DLUASOCKET_DEBUG -DLUA_COMPAT_APIINTCASTS" \
	#

%install
%makeinstall_std \
	LUAPATH=%lua_modulesdir_noarch \
	LUACPATH=%lua_modulesdir \
	#

%files
%doc CHANGELOG LICENSE* README*
%lua_modulesdir/*
%lua_modulesdir_noarch/*

%changelog
