%define target_lua_version 5.3

# Original package name luaprompt
%define oname luaprompt
%define oversion dev-1
%define rockspec luaprompt-dev-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 0.8
Release: alt1_lr1
Summary: Lua REPL with pretty-printing and auto-completion
License: MIT/X11
Group: Development/Other
Url: https://github.com/dpapavas/luaprompt
Vcs: git+https://github.com/dpapavas/luaprompt.git

Source: %oname-%version.tar
Source1: https://luarocks.org/manifests/luarocks/luaprompt-dev-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
BuildRequires: lua%target_lua_version(argparse) 
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks
BuildRequires: libreadline-devel

%description
luaprompt is both an interactive Lua prompt that can be used instead
of the official interpreter, as well as module that provides a Lua
command prompt that can be embedded in a host application.  As a
standalone interpreter it provides many conveniences that are missing
from the official Lua interpreter.  As an embedded prompt, it's meant
for applications that use Lua as a configuration or interface language
and can therefore benefit from an interactive prompt for debugging or
regular use.

luaprompt features:

* Readline-based input with history and completion: In particular all
  keywords, global variables and table accesses (with string or
  integer keys) can be completed in addition to readline's standard
  file completion.  Module names are also completed, for modules
  installed in the standard directories, and completed modules can
  optionally be loaded.

* Persistent command history (retained across sessions), as well as
  recording of command results for future reference.

* Proper value pretty-printing for interactive use: When an expression
  is entered at the prompt, all returned values are printed
  (prepending with an equal sign is not required).  Values are printed
  in a descriptive way that tries to be as readable as possible.  The
  formatting tries to mimic Lua code (this is done to minimize
  ambiguities and no guarantees are made that it is valid code).
  Additionally, each value is stored in a table for future reference.

* Color highlighting of error messages and variable printouts.


%prep
%setup -n %oname-%version

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc
mv %buildroot%_bindir/luap{,-%target_lua_version}
find %buildroot -type f -name 'luap' \
  -exec grep 'env lua$' {} \; \
  -exec subst 's/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%_bindir/*
%lua_modulesdir/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc ChangeLog* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%changelog
