%define _unpackaged_files_terminate_build 1
%define target_lua_version 5.3

# Original package name LuaFileSystem
%define oname luafilesystem
%define oversion 1.8.0-1
%define rockspec luafilesystem-1.8.0-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 1.8.0
Release: alt4_lr1
Summary: File System Library for the Lua Programming Language
License: MIT
Group: Development/Other
Url: https://lunarmodules.github.io/luafilesystem/
Vcs: https://github.com/lunarmodules/luafilesystem

# These Obsoletes/Provides only necessary when previous (out-of-poicy) versions exist in repo
%if "%target_lua_version" == "5.4"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%else
Obsoletes: lua5-%oname < %EVR
Provides: lua5-%oname = %version
%endif

Source: https://github.com/lunarmodules/luafilesystem/archive/refs/tags/v1_8_0.tar.gz#/%oname-1_8_0.tar.gz
Source1: https://luarocks.org/manifests/luarocks/luafilesystem-1.8.0-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks

%description
      LuaFileSystem is a Lua library developed to complement the set of
      functions related to file systems offered by the standard Lua
      distribution. LuaFileSystem offers a portable way to access the
      underlying directory structure and file attributes.

%prep
%setup -n %oname-1_8_0

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc
find %buildroot -type f -name '*.lua' \
  -exec grep 'env lua$' {} \; \
  -exec subst 's/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

%check
%lua_path_add_buildroot
for t in %buildroot%luarocks_dbdir_prefix-%target_lua_version/%oname/%oversion/tests/* ; do
  lua%target_lua_version $t
done

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%lua_modulesdir/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc LICENSE* README* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%changelog
