%define target_lua_version 5.1

# Original package name compat53
%define oname compat53
%define oversion 0.14.4-1
%define rockspec compat53-0.14.4-1.rockspec
%define lua_incdir %_includedir/lua-%target_lua_version

Name: lua%target_lua_version-module-%oname
Version: 0.14.4
Release: alt1_lr1
Summary: Compatibility module providing Lua-5.3-style APIs for Lua 5.2 and 5.1
License: MIT
Group: Development/Other
Url: https://github.com/lunarmodules/lua-compat-5.3
Provides: luarocks%target_lua_version(%oname) = %EVR

Source: https://github.com/lunarmodules/lua-compat-5.3/archive/v0.14.4.tar.gz#/lua-compat-5.3-%version.tar.gz
Source1: https://luarocks.org/manifests/luarocks/compat53-0.14.4-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks

%description
This is a small module that aims to make it easier to write Lua
code in a Lua-5.3-style that runs on Lua 5.1+.
It does *not* make Lua 5.2 (or even 5.1) entirely compatible
with Lua 5.3, but it brings the API closer to that of Lua 5.3.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version
%description devel
This package contains development files for %name.

%prep
%setup -n lua-compat-5.3-%version

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc
find %buildroot -type f -name '*.lua' \
  -exec grep 'env lua$' {} \; \
  -exec subst 's/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

install -d -m 0755 %buildroot%lua_incdir/c-api
install -m 0644 -p -t %buildroot%lua_incdir/c-api c-api/*
install -m 0644 lprefix.h %buildroot%lua_incdir/lprefix.h

%check
%lua_path_add_buildroot
export CC="gcc" CFLAGS="-Wall -Wextra -Ic-api -O2 -fPIC"
DEF="-DCOMPAT53_PREFIX=compat53" SRC="c-api/compat-5.3.c"
${CC} ${CFLAGS} -shared -o tests/testmod.so tests/testmod.c ${SRC}
cd tests
lua%target_lua_version test.lua

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%lua_modulesdir/*
%lua_modulesdir_noarch/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%files devel
%lua_incdir

%changelog
