%define _unpackaged_files_terminate_build 1

Name: lnav
Version: 0.13.0
Release: alt1

Summary: The log file navigator
License: BSD
Group: File tools
Url: https://github.com/tstack/lnav
Vcs: http://lnav.org

Source0: %{name}-%{version}.tar.bz2
Source1: %name.watch
Patch0: lnav-0.4.0-alt-fixes.patch
Patch1: lnav-fix_32bit_use_size_t.patch
Patch2: 0001-fix-build-on-GCC13.patch
Patch3500: lnav-loongarch64.patch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Mon Jun 23 2014
# optimized out: libcloog-isl4 libpcre-devel libstdc++-devel libtinfo-devel python-base
BuildRequires: bzlib-devel gcc-c++ libncursesw-devel libpcrecpp-devel libreadline-devel libsqlite3-devel sqlite3 zlib-devel
BuildRequires: libcurl-devel
# check
BuildRequires: openssh-common

%description
The log file navigator, lnav, is an enhanced log file viewer that
takes advantage of any semantic information that can be gleaned
from the files being viewed, such as timestamps and log levels.
Using this extra semantic information, lnav can do things like
interleaving messages from different files, generate histograms
of messages over time, and providing hotkeys for navigating
through the file.  It is hoped that these features will allow
the user to quickly and efficiently zero in on problems.

%prep
%setup
%patch2 -p1
%patch3500 -p1
sed -i 's,var/log/syslog,&/messages,g' src/lnav.cc
touch AUTHORS ChangeLog COPYING

%build
%autoreconf
%configure --disable-static
%make_build CXXFLAGS+="-I%_includedir/pcre"

%install
%makeinstall_std

%files
%_bindir/*
%_man1dir/*
%doc LICENSE README

# TODO:
# - they really should use pkg-config wrt libpcre
# - and check for /dev/ptmx or whatever to have opened ok
#   (putting out meaningful diags otherwise, e.g. in a chroot)

%changelog
