%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: lkrg
Version: 1.0.0
Release: alt1

Summary: Linux Kernel Runtime Guard module
License: GPL-2.0-only
Group: System/Configuration/Other
Url:  https://lkrg.org/
Vcs: https://github.com/lkrg-org/lkrg
Requires: lkrg-common

Source: %name-%version.tar
ExclusiveArch: aarch64 armh %ix86 x86_64

BuildRequires(pre): rpm-build-kernel
%{?!_without_check:%{?!_disable_check:
BuildRequires: kernel-headers-modules-%kernel_latest
BuildRequires: shellcheck
}}

%define _descr %{expand:
Linux Kernel Runtime Guard (LKRG) is a loadable kernel module that performs
runtime integrity checking of the Linux kernel and detection of security
vulnerability exploits against the kernel. As controversial as this concept is,
LKRG attempts to post-detect and hopefully promptly respond to unauthorized
modifications to the running Linux kernel (integrity checking) or to
credentials (such as user IDs) of the running processes (exploit
detection). For process credentials, LKRG attempts to detect the exploit and
take action before the kernel would grant the process access (such as open a
file) based on the unauthorized credentials.
}

%description
%_descr

%package -n kernel-source-lkrg
Summary: This package contains the LKRG sources
BuildArch: noarch
Group: Development/Kernel

%description -n kernel-source-lkrg
%_descr

This package contains the LKRG sources.

%package common
Summary: Common files for Linux Kernel Runtime Guard module
BuildArch: noarch
Group: System/Configuration/Other
Provides: lkrg-config = %EVR
Obsoletes: lkrg-config < %EVR

%description common
%_descr

This package contains common files for Linux Kernel Runtime Guard.

%package logger
Summary: LKRG remote logging receiving tools
Group: System/Servers

%description logger
LKRG supports optional remote kernel message logging.  Once enabled, this logs
not only messages generated by LKRG, but also all other kernel messages.

The sending component is in the LKRG kernel module itself, whereas the
receiving and logging counterpart is in a userspace daemon.  There are also
additional userspace utilities.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build -C logger LDFLAGS="" CFLAGS="%optflags"

%install
install -pDm644 %_sourcedir/%name-%version.tar %kernel_srcdir/kernel-source-%name-%version.tar
install -Dpm644 scripts/bootup/lkrg.conf -t %buildroot%_sysconfdir
install -Dp lkrg.init %buildroot%_initdir/lkrg

mkdir -p %buildroot%_unitdir
cat <<EOF >%buildroot%_unitdir/lkrg.service
[Unit]
Description=Linux Kernel Runtime Guard
DefaultDependencies=no
After=systemd-modules-load.service
Before=systemd-sysctl.service
Before=sysinit.target shutdown.target
Conflicts=shutdown.target
ConditionKernelCommandLine=!nolkrg

[Service]
Type=oneshot
ExecStart=/etc/rc.d/init.d/lkrg start
ExecStop=/etc/rc.d/init.d/lkrg stop
RemainAfterExit=yes

[Install]
WantedBy=sysinit.target
EOF

mkdir -p %buildroot%_presetdir
cat <<EOF >%buildroot%_presetdir/30-lkrg.preset
enable lkrg.service
EOF

%makeinstall_std -C logger PREFIX=%_usr UNITDIR=%_unitdir
mkdir -p %buildroot%_logdir/lkrg-logger
touch %buildroot%_sysconfdir/lkrg-logger.conf

%check
bash -n lkrg.init
shellcheck -x lkrg.init

%preun common
%preun_service lkrg

%pre -n kernel-source-lkrg
[ -d /.host -a -d /.in -a -d /.out ] || {
	echo >&2 '%name is not allowed outside hasher environments'
	exit 1
}

%post logger
groupadd -r lkrg-logger
useradd -r lkrg-logger -g lkrg-logger -d /var/empty -s /dev/null
test $1 -eq 1 && ! test -s %_sysconfdir/lkrg-logger.conf && lkrg-keygen > %_sysconfdir/lkrg-logger.conf
%post_service lkrg-logger

%preun logger
%preun_service lkrg-logger

%files -n kernel-source-lkrg
%kernel_src/kernel-source-%name-%version.tar

%files common
%config(noreplace) %_sysconfdir/lkrg.conf
%_initdir/lkrg
%_unitdir/lkrg.service
%_presetdir/30-lkrg.preset

%files logger
%attr(0750,lkrg-logger,lkrg-logger) %dir %_logdir/lkrg-logger
%attr(0600,root,root) %config(noreplace) %_sysconfdir/lkrg-logger.conf
%_sbindir/lkrg-keygen
%_sbindir/lkrg-logctl
%_sbindir/lkrg-logger
%_unitdir/lkrg-logger.service

%changelog
