%def_with x
%def_with directfb
%def_without svgalib

Name: links2
Version: 2.30
Release: alt1

Summary: Lynx-like text and graphics WWW browser
# actually GPLv2+ with OpenSSL exception, stupid SPDX doesn't grok that
License: GPLv2+ and MPL-2.0
Group: Networking/WWW

Url: http://links.twibright.com
Source0: %url/download/links-%version.tar.gz
Source100: %name.watch

%if_with directfb
BuildPreReq: libdirectfb-devel
%endif

%if_with svgalib
BuildPreReq: svgalib-devel
%endif

%if_with x
BuildPreReq: libXt-devel
%endif

# alternatives
%define weight 20
Requires(pre,postun): alternatives >= 0.2.0
BuildPreReq: alternatives >= 0.2.0

Provides: webclient, links
Provides: %_bindir/links
Obsoletes: links

# Automatically added by buildreq on Tue Apr 10 2012
# optimized out: alternatives libX11-devel libcom_err-devel libkrb5-devel libsysfs-devel pkg-config xorg-xproto-devel zlib-devel
BuildRequires: bzlib-devel libXt-devel libdirectfb-devel libgpm-devel libjpeg-devel liblzma-devel libpng-devel libssl-devel libtiff-devel

BuildRequires: libSDL-devel
BuildRequires: libevent-devel
BuildRequires: libbrotli-devel

Summary(ru_RU.UTF-8): Текстовый и графический веб-браузер, похожий на Lynx

%description
Links is a graphics and text mode web browser, released under GPL.
Links runs in graphics mode (mouse required) on X Window System (UN*X,
Cygwin), SVGAlib, Linux Framebuffer, OS/2 PMShell, AtheOS GUI.
Links runs in text mode (mouse optional) on UN*X console, ssh/telnet
virtual terminal, vt100 terminal, xterm, and virtually any other text
terminal. Mouse is supported for GPM, xterm, and OS/2. Links supports
colors on terminal.

%description -l ru_RU.UTF-8
Links - веб-браузер для графического и текстового режима, выпущенный
под лицензией GPL.

В графическом режиме требует мышь и работает на X Window System
(UN*X, Cygwin), SVGAlib, Linux Framebuffer, OS/2 PMShell, AtheOS GUI.

В текстовом режиме может использовать мышь и работает на UN*X-консоли,
виртуальных терминалах ssh/telnet, vt100, xterm и практически любых
других текстовых. Мышь поддерживается на GPM, xterm и OS/2.
Links умеет цвета в терминале.

%prep
%setup -n links-%version

%build
%add_optflags -Wno-pointer-sign -fno-strict-aliasing
%configure \
	--enable-graphics \
	%{subst_with x} \
	%{subst_with directfb} \
	%{subst_with svgalib} \
	--enable-debuglevel=0
	#--enable-javascript
%make_build

%install
%makeinstall

mv %buildroot%_bindir/links %buildroot%_bindir/links-%version
ln -s links-%version %buildroot%_bindir/%name
mv %buildroot%_man1dir/links.1 %buildroot%_man1dir/%name.1

install -pDm644 links_16x16_1.xpm %buildroot%_miconsdir/%name.xpm
install -pDm644 links_32x32.xpm %buildroot%_niconsdir/%name.xpm
install -pDm644 graphics/links.xpm %buildroot%_liconsdir/%name.xpm

mkdir -p %buildroot%_altdir
cat <<__EOF__ >%buildroot%_altdir/%name
%_bindir/links	%_bindir/%name	%weight
%_man1dir/links.1.gz	%_man1dir/%name.1.gz	%_bindir/%name
__EOF__

mkdir -p %buildroot%_desktopdir
cat <<__EOF__ >%buildroot%_desktopdir/%name.desktop
[Desktop Entry]
Type=Application
Name=Links 2
Exec=xlinks2
Terminal=false
Categories=Network;WebBrowser;
Comment=Web browser running in both graphics and text mode
__EOF__

cat <<__EOF__ >%buildroot%_bindir/x%name
#!/bin/sh
exec links2 -g "$@"
__EOF__
chmod +x %buildroot%_bindir/x%name

%files
%_altdir/%name
%_bindir/%name
%_bindir/x%name
%_bindir/links-%version
%_desktopdir/%name.desktop
%_miconsdir/%name.xpm
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_man1dir/*
%doc doc/
%doc AUTHORS BRAILLE_HOWTO ChangeLog INSTALL KEYS NEWS 
#doc PATCH-gpm-1.20.0-smooth-cursor PATCH-libpng-1.2.18 
%doc README SITES mailcap.pl

# TODO:
# - consider system publicsuffix like debian

%changelog
