%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name: lightdm-kde-greeter
Version: 6.0.3
Release: alt2
Group: Graphical desktop/Other
Summary: LightDM KDE6 Greeter
License: GPL-3.0+
Url: https://invent.kde.org/plasma/lightdm-kde-greeter.git

Source: %name-%version.tar

Patch1: add-russian-translations-to-desktop-files.patch
Patch2: fix-the-focus-on-the-userlist-at-startup.patch

%ifarch aarch64
%define optflags_lto %nil
%endif

%K6init

BuildRequires(pre): rpm-build-kf6
BuildRequires(pre): rpm-build-qml6
BuildRequires(pre): rpm-build-ubt
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: lightdm-devel
BuildRequires: libgtk+2-devel
BuildRequires: libXrandr-devel
BuildRequires: qt6-base-devel qt6-declarative-devel qt6-tools-devel qt6-tools-devel qt6-5compat-devel qt6-shadertools-devel
BuildRequires: extra-cmake-modules
BuildRequires: kf6-kdeclarative-devel kf6-kiconthemes-devel plasma6-lib-devel kf6-kconfig-devel kf6-ki18n-devel kf6-kauth-devel kf6-kconfigwidgets-devel
BuildRequires: kf6-kcmutils-devel
# deps of used stuff
BuildRequires: kf6-kcoreaddons-devel kf6-kpackage-devel kf6-kservice-devel
BuildRequires: kf6-networkmanager-qt-devel

Requires: lightdm
Requires: plasma-workspace-qml
Requires: polkit

Provides: lightdm-greeter

%description
This package provides a KDE-based LightDM greeter engine.

This is a fork of KDE4-based LightDM greeter engine for KDE6.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%K6build \
%_K6if_ver_gteq %ubt_id M110
        -DGREETER_WAYLAND_SESSIONS_FIRST=ON \
%endif
        -DGREETER_IMAGES_DIR=%_var/lib/ldm/%name/images

%install
%K6install
%K6install_move data kcm_lightdm kpackage

%find_lang --with-kde %name
%find_lang --with-kde --append --output=%name.lang kcm_lightdm
%find_lang --with-kde --append --output=%name.lang lightdm_kde_greeter
%find_lang --with-kde --append --output=%name.lang lightdm_theme_userbar

# Add alternatives for xgreeters
mkdir -p %buildroot%_altdir
printf '%_datadir/xgreeters/lightdm-default-greeter.desktop\t%_datadir/xgreeters/lightdm-kde-greeter.desktop\t300\n' > %buildroot%_altdir/lightdm-kde-greeter

%files -f %name.lang
%config(noreplace) %_sysconfdir/lightdm/lightdm-kde-greeter.conf
%_altdir/lightdm-kde-greeter
%_sbindir/lightdm-kde-greeter
%_datadir/xgreeters/lightdm-kde-greeter.desktop
%_datadir/dbus-1/system.d/org.kde.kcontrol.kcmlightdm.conf
%_K6libexecdir/kf6/kauth/kcmlightdmhelper
%_K6libexecdir/lightdm-kde-greeter-rootimage
%_K6libexecdir/lightdm-kde-greeter-wifikeeper
%_K6dbus_sys_srv/org.kde.kcontrol.kcmlightdm.service
%_libexecdir/systemd/user/lightdm-kde-greeter-wifikeeper.service
%_datadir/lightdm-kde-greeter/
%_K6xdgapp/kcm_lightdm.desktop
%_K6plug/plasma/kcms/systemsettings/kcm_lightdm.so
%_datadir/polkit-1/actions/org.kde.kcontrol.kcmlightdm.policy


%changelog
