%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define _name xkbcommon

%def_enable x11
%def_enable xkbregistry
%def_enable docs
%def_enable check
# broken in hasher
%def_disable python_tests

Name: lib%_name
Version: 1.12.2
Release: alt1

Summary: X.Org X11 XKB parsing library
Group: System/Libraries
License: MIT
Url: https://www.xkbcommon.org

Vcs: https://github.com/xkbcommon/libxkbcommon.git

%if_disabled snapshot
#Source: %url/download/%name-%version.tar.xz
Source: https://github.com/xkbcommon/libxkbcommon/archive/%_name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson %{?_enable_check:rpm-macros-valgrind}
BuildRequires: meson >= 0.51 bison >= 3.6 flex
BuildRequires: xkeyboard-config-devel >= 2.29
# since 7.0 for wayland utilities
BuildRequires: wayland-devel >= 1.14 libwayland-client-devel wayland-protocols >= 1.10
BuildRequires: pkgconfig(icu-uc)
BuildRequires: bash-completion
%{?_enable_x11:BuildRequires: pkgconfig(xcb) pkgconfig(xcb-xkb) >= 1.10}
%{?_enable_xkbregistry:BuildRequires: libxml2-devel}
%{?_enable_docs:BuildRequires: doxygen graphviz}
%{?_enable_check:BuildRequires: python3(pytest) python3(jinja2) %{?_enable_x11:xvfb-run}
BuildRequires: setxkbmap
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif}

%description
%name is the X.Org library for compiling XKB maps into formats usable by
the X Server or other display servers.

%package devel
Summary: X.Org X11 XKB parsing development package
Group: Development/C
Requires: %name = %EVR

%description devel
X.Org X11 XKB parsing development package

%package x11
Summary: X.Org X11 XKB keymap creation library
Group: System/Libraries
Requires: %name = %EVR

%description x11
%name-x11 is the X.Org library for creating keymaps by querying the X
server.

%package x11-devel
Summary: X.Org X11 XKB keymap creation library
Group: System/Libraries
Requires: %name-x11 = %EVR
Requires: %name-devel = %EVR

%description x11-devel
X.Org X11 XKB keymap creation library development package

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains development documentation for %name.

%package tools
Summary: Tools from %name package
Group: Development/Tools
Requires: %name = %EVR
Requires: %name-x11 = %EVR

%description tools
This package provides xkbcli -- tool to interact with XKB keymaps.

%prep
%setup -n %name%{?_disable_snapshot:-%_name}-%version

%ifarch %e2k
sed -i 's/--undefined-version,//' meson.build
%endif

%build
%meson \
    -Ddefault_library=shared \
    %{subst_enable_meson_bool x11 enable-x11} \
    %{subst_enable_meson_bool xkbregistry enable-xkbregistry} \
    %{subst_enable_meson_bool docs enable-docs}
%nil
%meson_build

%install
%meson_install

%check
%{?_enable_x11:xvfb-run} %__meson_test %{?_disable_python_tests:--no-suite python-tests}

%files
%_libdir/%name.so.*
%{?_enable_xkbregistry:%_libdir/libxkbregistry.so.*}
%doc LICENSE NEWS* README*

%files devel
%_libdir/%name.so
%dir %_includedir/%_name/
%_includedir/%_name/%_name.h
%_includedir/%_name/%_name-compat.h
%_includedir/%_name/%_name-compose.h
%_includedir/%_name/%_name-keysyms.h
%_includedir/%_name/%_name-names.h
%_pkgconfigdir/%_name.pc
%{?_enable_xkbregistry:%_libdir/libxkbregistry.so
%_includedir/%_name/xkbregistry.h
%_pkgconfigdir/xkbregistry.pc}

%{?_enable_docs:
%files devel-doc
%_datadir/doc/%name/}

%if_enabled x11
%files x11
%_libdir/%name-x11.so.*

%files x11-devel
%_libdir/%name-x11.so
%_includedir/%_name/%_name-x11.h
%_pkgconfigdir/%_name-x11.pc
%endif

%files tools
%_bindir/xkbcli
%dir %_libexecdir/%_name
%_libexecdir/%_name/xkbcli-*
%_datadir/bash-completion/completions/xkbcli
%_man1dir/xkbcli*

%changelog
