%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define oname wpd
%define soname 10

Name: lib%oname%soname
Version: 0.10.3
Release: alt2
Summary: Library for reading and converting WordPerfect(tm) documents
License: LGPLv2+ or MPL-2.0
Group: System/Libraries
Url: http://libwpd.sf.net/

Source: libwpd-%version.tar

Patch1: libwpd-alt-build.patch

BuildRequires: boost-devel-headers help2man librevenge-devel
BuildRequires: gcc-c++
BuildRequires: doxygen
BuildRequires: pkgconfig(cppunit)
BuildRequires: pkgconfig(zlib)

Obsoletes: libwpd9 >= 0.10.0

%description
Library that handles Word Perfect documents

%package tools
Summary: Tools to transform WordPerfect Documents into other formats
Group: Publishing
Requires: %name = %EVR
Conflicts: libwpd-tools < %version
Conflicts: libwpd9-tools < %version
Provides: lib%oname-tools = %EVR

%description tools
Tools to transform WordPerfect Documents into other formats.
Currently supported: html, raw, text

%package devel
Summary: Files for developing with libwpd
Group: Development/C++
Requires: %name = %EVR
Conflicts: libwpd-devel < %version
Conflicts: libwpd9-devel < %version
Provides: lib%oname-devel = %EVR

%description devel
Includes and definitions for developing with libwpd

%package doc
Summary: Documentation of %name API
Group: Documentation
BuildArch: noarch
Provides: lib%oname-doc = %EVR

%description doc
The %name-doc package contains API documentation for %name.

%prep
%setup -n lib%oname-%version
%patch1 -p2

%build
%autoreconf
%configure --disable-static --disable-werror
%make_build

export LD_LIBRARY_PATH=`pwd`/src/lib/.libs${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}
help2man -N -n 'debug the conversion library' -o wpd2raw.1 ./src/conv/raw/.libs/wpd2raw
help2man -N -n 'convert WordPerfect document into HTML' -o wpd2html.1 ./src/conv/html/.libs/wpd2html
help2man -N -n 'convert WordPerfect document into plain text' -o wpd2text.1 ./src/conv/text/.libs/wpd2text

%install
%makeinstall_std
# we install API docs directly from build
rm -rf %buildroot%_docdir/libwpd

install -m 0755 -d %buildroot%_man1dir
install -m 0644 wpd2*.1 %buildroot%_man1dir/

%check
LD_LIBRARY_PATH=../lib/.libs make check

%files
%doc COPYING.LGPL COPYING.MPL CREDITS README
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files tools
%_bindir/*
%_man1dir/*.1*

%files devel
%doc HACKING TODO
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files doc
%doc COPYING.LGPL COPYING.MPL
%doc docs/doxygen/html
%doc docs/*.dia
%doc docs/*.png

%changelog
