%define _unpackaged_files_terminate_build 1

Name: libwebsockets
Version: 4.3.5
Release: alt1

Summary: A lightweight C library for Websockets

License: MIT and Apache-2.0 and BSD-3-Clause and Zlib and CC0
Group: Development/C
Url: http://libwebsockets.org

# Source-url: https://github.com/warmcat/libwebsockets/archive/v%version.tar.gz#/%name-%version.tar.gz
Source: %name-%version.tar

Patch: libwebsockets-4.3.2-alt-upstream-gcc13.patch

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libssl-devel
BuildRequires: zlib-devel
BuildRequires: libev-devel
BuildRequires: libuv-devel
BuildRequires: glib2-devel
BuildRequires: libcap-devel

# https://fedoraproject.org/wiki/Bundled_Libraries
Provides: bundled(sha1-hollerbach)
Provides: bundled(base64-decode)
Provides: bundled(ssl-http2)

%description
This is the libwebsockets C library for lightweight websocket clients and
servers.

%package devel
Group: Development/C
Summary: Headers for developing programs that will use %name
Requires: %name = %EVR

%description devel
This package contains the header files needed for developing
%name applications.

%package tests
Group: Development/C
Summary: Tests to use with %name
Requires: %name = %EVR

%description tests
This package contains the tests for %name applications.

%prep
%setup
#patch -p1

%build
%cmake \
    -DLWS_LINK_TESTAPPS_DYNAMIC=ON \
    -DLWS_WITH_EVLIB_PLUGINS=ON \
    -DLWS_WITH_LIBUV=ON \
    -DLWS_WITH_LIBEV=ON \
    -DLWS_WITH_GLIB=ON \
    -DLWS_WITHOUT_BUILTIN_GETIFADDRS=ON \
    -DLWS_USE_BUNDLED_ZLIB=OFF \
    -DLWS_WITHOUT_BUILTIN_SHA1=ON \
%ifarch %e2k
    -DDISABLE_WERROR=ON \
%endif
    -DLWS_WITH_STATIC=OFF
%cmake_build

%install
%cmakeinstall_std
find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name '*.a' -exec rm -f {} ';'
find %buildroot -name '*.cmake' -exec rm -f {} ';'
find %buildroot -name '*_static.pc' -exec rm -f {} ';'

%files
%doc README.md changelog
%doc LICENSE
%_libdir/%name.so.*
%_libdir/%name-evlib_*.so

%files devel
%doc READMEs/README.coding.md READMEs/ changelog
%doc LICENSE
%_includedir/%name.h
%_includedir/lws_config.h
%_includedir/%name
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%files tests
%doc READMEs/README.coding.md READMEs/README.test-apps.md
%doc LICENSE
%_bindir/%name-test-*
%_datadir/%name-test-server/

%changelog
