%set_verify_elf_method textrel=relaxed
%define optflags_lto %nil

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec
%def_disable soup2
%def_enable gtk4

%if_enabled soup2
%define api_ver 4.0
%def_disable webdriver
%else
%if_enabled gtk4
%define api_ver 6.0
%def_enable webdriver
%else
%define api_ver 4.1
%def_disable webdriver
%endif
%endif

%define pkglibexecdir %_libexecdir/webkitgtk-%api_ver
%define ver_major 2.48

%define oname webkit
%define _name webkitgtk
%define bwrap_bin %_bindir/bwrap

%def_enable ninja
%def_disable gtkdoc
%def_enable gold
%def_enable x11
%def_enable wayland
%def_enable systemd
%def_disable soup2
%def_enable libavif
%def_enable speech_synthesis
# we have no libjxl for armh
%ifarch armh
%def_disable jpegxl
%else
%def_enable jpegxl
%endif
%def_enable sysprof

# since 2.19.x in some build environments
# while build webki2gtk-dep typelibs this error appears
# FATAL: Could not allocate gigacage memory with maxAlignment = ..
# To avoid it set GIGACAGE_ENABLED=0
%def_enable gigacage

%def_enable bubblewrap_sandbox

Name: libwebkitgtk%api_ver
Version: %ver_major.1
Release: alt1

Summary: Web browser engine
Group: System/Libraries
License: LGPL-2.0
Url: https://www.webkitgtk.org/

Source: %url/releases/%_name-%version.tar.xz
Source1: webkit2gtk.env
Patch2000: webkitgtk-2.34.3-alt-e2k.patch

%define bwrap_ver 0.3.1
%define soup_ver 2.62
%define soup_api_ver 3.0
%define soup3_ver 3.4.4
%define gtk_ver 3.22
%define gtk4_ver 4.6.0
%define gst_ver 1.24.9

BuildRequires(pre): rpm-macros-cmake rpm-build-gir rpm-build-python3
BuildRequires: /proc gcc-c++ cmake unifdef
%{?_enable_ninja:BuildRequires: ninja-build}
BuildRequires: ccache libicu-devel >= 5.6.1 bison
BuildRequires: perl-Switch perl-JSON-PP perl-bignum
BuildRequires: zlib-devel
BuildRequires: flex >= 2.5.33
BuildRequires: gperf libjpeg-devel libpng-devel libwebp-devel liblcms2-devel
BuildRequires: libopenjpeg2.0-devel openjpeg-tools2.0
BuildRequires: libxml2-devel >= 2.6
BuildRequires: libXt-devel
%if_enabled gtk4
BuildRequires: libgtk4-devel >= %gtk4_ver
%else
BuildRequires: libgtk+3-devel >= %gtk_ver
%endif
BuildRequires: libepoxy-devel
BuildRequires: libenchant2-devel >= 2.2.3
BuildRequires: libsqlite3-devel >= 3.0
BuildRequires: libxslt-devel >= 1.1.7
BuildRequires: gstreamer1.0-devel >= %gst_ver gst-plugins1.0-devel >= %gst_ver gst-plugins-bad1.0-devel
BuildRequires: librsvg-devel >= 2.2.0
BuildRequires: gi-docgen
%if_enabled soup2
BuildRequires: libsoup-devel >= %soup_ver libsoup-gir-devel
%else
BuildRequires: libsoup%soup_api_ver-devel >= %soup3_ver libsoup%soup_api_ver-gir-devel
%endif
BuildRequires: libsecret-devel
BuildRequires: libpango-devel >= 1.21.0 libcairo-devel >= 1.10 libcairo-gobject-devel
BuildRequires: fontconfig-devel >= 2.4 libfreetype-devel libharfbuzz-devel libwoff2-devel
BuildRequires: libgio-devel >= 2.25.0
BuildRequires: ruby ruby-stdlibs
BuildRequires: libdrm-devel libgbm-devel
BuildRequires: libGL-devel libGLES-devel
BuildRequires: libXcomposite-devel libXdamage-devel
BuildRequires: gobject-introspection-devel >= 0.9.5
%if_enabled gtk4
BuildRequires: libgtk4-gir-devel
%else
BuildRequires: libgtk+3-gir-devel
%endif
BuildRequires: geoclue2-devel libgeoclue2-devel
BuildRequires: libenchant-devel libhyphen-devel
BuildRequires: libat-spi2-core-devel at-spi2-atk-devel
BuildRequires: libpixman-devel libexpat-devel
BuildRequires: libXdmcp-devel libxshmfence-devel libXxf86vm-devel
BuildRequires: libXinerama-devel libXi-devel libXrandr-devel
BuildRequires: libXcursor-devel libxkbcommon-devel
%{?_enable_wayland:BuildRequires: libwayland-server-devel libwayland-cursor-devel libwayland-egl-devel wayland-protocols}
BuildRequires: libgnutls-devel libnettle-devel
BuildRequires: libtasn1-devel libp11-kit-devel libgcrypt-devel
# for battery status
BuildRequires: libupower-devel
# since 2.25.x 
#BuildRequires: libwpe-devel libwpebackend-fdo-devel >= 1.8.0
# since 2.31.x
BuildRequires: libmanette-devel
%{?_enable_bubblewrap_sandbox:BuildRequires: bubblewrap >= %bwrap_ver xdg-dbus-proxy libseccomp-devel}
# since 2.29.x 
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
# since 2.34.0
%{?_enable_libavif:BuildRequires: libavif-devel}
%{?_enable_speech_synthesis:BuildRequires: flite-devel >= 2.2}
# since 2.39.x
%{?_enable_jpegxl:BuildRequires: libjxl-devel}
# since 2.43.x
BuildRequires: libbacktrace-devel
# since 2.45.x
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}

%description
WebKit is an open source web browser engine.
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

%package -n %name-minibrowser
Summary: Simple WebKit browser
Group: Networking/WWW
Requires: libwebkitgtk%api_ver = %EVR

%description -n %name-minibrowser
This package provides simple browser from webkitgtk project.

%package -n libwebkitgtk%api_ver-devel
Summary: Development files for WebKit GTK+ port
Group: Development/C++
Requires: libwebkitgtk%api_ver = %EVR
Requires: libjavascriptcoregtk%api_ver-devel = %EVR

%description -n libwebkitgtk%api_ver-devel
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux. This package contains development headers.

%package -n libwebkitgtk%api_ver-devel-doc
Summary: Development documentation for WebKitGTK
Group: Development/Documentation
BuildArch: noarch
Conflicts: libwebkitgtk%api_ver < %version-%release

%description -n libwebkitgtk%api_ver-devel-doc
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

This package provides development documentation for WebKitGTK.

%package -n libjavascriptcoregtk%api_ver
Summary: GTK+3 version of the JavaScriptCore engine
Group: System/Libraries

%description -n libjavascriptcoregtk%api_ver
This package provides GTK+3 version of the JavaScriptCore engine from
WebKit package.

%package -n libjavascriptcoregtk%api_ver-devel
Summary: Development files for JavaScriptCore library
Group: Development/C++
Requires: libjavascriptcoregtk%api_ver = %EVR

%description -n libjavascriptcoregtk%api_ver-devel
This package provides development files for GTK+3 version of the
JavaScriptCore engine.

%package -n jsc%api_ver
Summary: JavaScriptCore shell for WebKit GTK+
Group: Development/GNOME and GTK+
Requires: libjavascriptcoregtk%api_ver = %EVR
#Conflicts: jsc4 jsc5

%description -n jsc%api_ver
jsc is a shell for JavaScriptCore, WebKit's JavaScript engine. It
allows you to interact with the JavaScript engine directly.

%package -n libwebkitgtk%api_ver-gir
Summary: GObject introspection data for the WebkitGTK library
Group: System/Libraries
Requires: libwebkitgtk%api_ver = %EVR
Requires: libjavascriptcoregtk%api_ver = %EVR
Requires: libjavascriptcoregtk%api_ver-gir  = %EVR

%description -n libwebkitgtk%api_ver-gir
GObject introspection data for the WebkitGTK library

%package -n libwebkitgtk%api_ver-gir-devel
Summary: GObject introspection devel data for the WebkitGTK library
Group: Development/Other
BuildArch: noarch
Requires: libwebkitgtk%api_ver-gir = %EVR
Requires: libwebkitgtk%api_ver-devel = %EVR
Requires: libjavascriptcoregtk%api_ver-gir = %EVR
Requires: libjavascriptcoregtk%api_ver-devel = %EVR
Requires: libjavascriptcoregtk%api_ver-gir-devel = %EVR

%description -n libwebkitgtk%api_ver-gir-devel
GObject introspection devel data for the WebkitGTK library

%package -n libjavascriptcoregtk%api_ver-gir
Summary: GObject introspection data for the JavaScriptCore library
Group: System/Libraries
Requires: libjavascriptcoregtk%api_ver = %EVR

%description -n libjavascriptcoregtk%api_ver-gir
GObject introspection data for the JavaScriptCore library

%package -n libjavascriptcoregtk%api_ver-gir-devel
Summary: GObject introspection devel data for the JavaScriptCore library
Group: Development/Other
BuildArch: noarch
Requires: libjavascriptcoregtk%api_ver-gir = %EVR
Requires: libjavascriptcoregtk%api_ver-devel = %EVR

%description -n libjavascriptcoregtk%api_ver-gir-devel
GObject introspection devel data for the JavaScriptCore library

%prep
%setup -n %_name-%version
%ifarch %e2k
%patch2000 -p2 -b .e2k
%endif

# Remove bundled libraries
rm -rf Source/ThirdParty/gtest/
rm -rf Source/ThirdParty/qunit/

subst 's|Q\(unused-arguments\)|W\1|' Source/cmake/WebKitCompilerFlags.cmake

# fix flite.h include
[ ! -d %_includedir/flite ] && sed -i 's|<flite/flite.h>|<flite.h>|' Source/WebCore/platform/gstreamer/GUniquePtrFlite.h

%build
%ifarch %e2k
# because of this error on linking:
# "relocation truncated to fit: R_E2K_32_ABS"
%define optflags_debug -g0
%else
# Decrease debuginfo verbosity and use linker flags to reduce memory consumption
%define optflags_debug -g1
%endif
%add_optflags -Wl,--no-keep-memory
%{?_disable_gold: %add_optflags -Wl,--reduce-memory-overheads}
%add_optflags %(getconf LFS_CFLAGS) -Wno-error=return-type
%ifarch %e2k
# EDG frontend mistakenly sees it everywhere
# after each "if constexpr {} else {}" constuct
%add_optflags -Wno-return-type
%endif
%ifarch x86_64
%if_disabled gigacage
export GIGACAGE_ENABLED=0
%endif
%endif
export PYTHON=%__python3
%cmake \
%{?_enable_ninja:-GNinja} \
-DPORT=GTK \
-DPYTHON_EXECUTABLE=%__python3 \
-DCMAKE_BUILD_TYPE=Release \
-DENABLE_MINIBROWSER=ON \
%{?_disable_gtkdoc:-DENABLE_DOCUMENTATION:BOOL=OFF} \
%{?_enable_x11:-DENABLE_X11_TARGET:BOOL=ON} \
%{?_enable_wayland:-DENABLE_WAYLAND_TARGET:BOOL=ON} \
%{?_enable_libavif:-DUSE_AVIF:BOOL=ON} \
%{?_enable_speech_synthesis:-DENABLE_SPEECH_SYNTHESIS=ON} \
%{?_disable_jpegxl:-DUSE_JPEGXL=OFF} \
%{?_disable_gold:-DUSE_LD_GOLD:BOOL=OFF} \
%if_disabled bubblewrap_sandbox
-DENABLE_BUBBLEWRAP_SANDBOX=OFF \
%else
-DBWRAP_EXECUTABLE=%bwrap_bin \
%endif
%ifarch %arm
-DENABLE_GLES2=ON \
%endif
%ifarch armh
-DENABLE_JIT=OFF \
-DENABLE_C_LOOP=ON \
-DENABLE_SAMPLING_PROFILER=OFF \
-DUSE_SYSTEM_MALLOC=ON \
%endif
-DUSER_AGENT_BRANDING:STRING="ALTLinux" \
%{?_disable_systemd:-DUSE_SYSTEMD:BOOL=OFF} \
%{?_enable_soup2:-DUSE_SOUP2=ON} \
%{?_disable_webdriver:-DENABLE_WEBDRIVER=OFF} \
%{?_enable_gtk4:-DUSE_GTK4=ON} \
%{?_disable_sysprof:-DUSE_SYSTEM_SYSPROF_CAPTURE=NO}
%nil
%ifarch aarch64 x86_64
[ %__nprocs -lt 128 ] || export NPROCS=128
%endif
%cmake_build

%install
%cmake_install
%if_disabled gigacage
install -pD -m755 %SOURCE1 %buildroot%_rpmmacrosdir/webki2gtk.env
%endif

%find_lang WebKitGTK-%api_ver

%files -n libwebkitgtk%api_ver -f WebKitGTK-%api_ver.lang
%{?!_disable_webdriver:%_bindir/WebKitWebDriver}
%_libdir/libwebkitgtk-%api_ver.so.*
%dir %pkglibexecdir
%pkglibexecdir/WebKitNetworkProcess
%pkglibexecdir/WebKitWebProcess
%pkglibexecdir/WebKitGPUProcess
%dir %_libdir/webkitgtk-%api_ver
%dir %_libdir/webkitgtk-%api_ver/injected-bundle
%_libdir/webkitgtk-%api_ver/injected-bundle/libwebkitgtkinjectedbundle.so
%doc NEWS

%files -n libwebkitgtk%api_ver-devel
%_libdir/libwebkitgtk-%api_ver.so
%dir %_includedir/webkitgtk-%api_ver
%_includedir/webkitgtk-%api_ver/webkit
%_pkgconfigdir/webkitgtk-%api_ver.pc
%_pkgconfigdir/webkitgtk-web-process-extension-%api_ver.pc
%{?_disable_gigacage:%_rpmmacrosdir/webki2gtk.env}

%files -n %name-minibrowser
%pkglibexecdir/MiniBrowser

%if_enabled gtkdoc
%files -n libwebkitgtk%api_ver-devel-doc
%_gtk_docdir/*
%endif

%files -n libjavascriptcoregtk%api_ver
%_libdir/libjavascriptcoregtk-%api_ver.so.*

%files -n libjavascriptcoregtk%api_ver-devel
%_includedir/webkitgtk-%api_ver/jsc/
%_libdir/libjavascriptcoregtk-%api_ver.so
%_pkgconfigdir/javascriptcoregtk-%api_ver.pc

%files -n jsc%api_ver
%pkglibexecdir/jsc*

%files -n libwebkitgtk%api_ver-gir
%_typelibdir/WebKit-%api_ver.typelib
%_typelibdir/WebKitWebProcessExtension-%api_ver.typelib

%files -n libwebkitgtk%api_ver-gir-devel
%_girdir/WebKit-%api_ver.gir
%_girdir/WebKitWebProcessExtension-%api_ver.gir

%files -n libjavascriptcoregtk%api_ver-gir
%_typelibdir/JavaScriptCore-%api_ver.typelib

%files -n libjavascriptcoregtk%api_ver-gir-devel
%_girdir/JavaScriptCore-%api_ver.gir


%changelog
