%define origname v

Name:		libv
Version:	1.90
Release:	alt11
Summary:	V is a free, multiple platform C++ graphical user interface framework
License:	LGPL
Group:		Development/C++
Source0:	%origname-%version.tar.bz2
Patch:      libv-1.90-alt-make-3.82.patch
Patch1:     %name-g++8.patch
Patch2:     fix-build-on-aarch64.patch
URL:		http://www.objectcentral.com/
Packager:	Evgeny Sinelnikov <sin@altlinux.ru>
# Automatically added by buildreq on Thu Oct 25 2007
BuildRequires: gcc-c++ libXaw-devel libXmu-devel

BuildRequires:	lesstif-devel, libXext-devel, libGLw-devel, libGLU-devel

%description
V is a free, multiple platform C++ graphical user interface framework designed
to make it the easiest way to write C++ GUI applications available -- 
commercial, shareware, or freeware. V is available for X Athena, 
X Motif/Lesstif, all Windows platforms, and now including OS/2.

%package devel
Summary:        Development header files for %name
Group:          Development/C++
Requires:       %name = %version

%description devel
Libraries, include files and other resources you can use to develop
%name applications.

%prep
%setup -q -n home/vgui
%patch -p3
%patch1 -p2
%patch2 -p2

%build
perl -pi -e "s|^HOMEV\s*=.*|HOMEV=`pwd`|" Config.mk
CFLAGS="-I. -Wno-error=narrowing -fpermissive" make

%install
mkdir -p %buildroot%_libdir
mkdir -p %buildroot%_includedir

cp lib/lib* %buildroot%_libdir
rm -f %buildroot%_libdir/libVx.so
ln -s libVx.so.1.90 %buildroot%_libdir/libVx.so
ln -s libVxgl.so.1.90 %buildroot%_libdir/libVxgl.so

cp -r includex/* %buildroot%_includedir

perl -pi -e "s|\r\n|\n|" %buildroot%_includedir/v/*
perl -pi -e "s|\r\n|\n|"  ../help/vrefman/* Readme copying.lib

# It is the file in the package named Thumbs.db or Thumbs.db.gz, 
# which is normally a Windows image thumbnail database. 
# Such databases are generally useless in packages and were usually 
# accidentally included by copying complete directories from the source tarball.
find %buildroot \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete

%files
%doc Readme copying.lib
%_libdir/*.so.*

%files devel
%doc ../help/vrefman/*
%_includedir/%origname
%_libdir/*.so

%changelog
