# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dbus-binding-tool imake libXt-devel pkgconfig(dbus-glib-1) pkgconfig(gio-2.0) pkgconfig(x11) xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 3.0.2
%define major		0
%define api		3.0
%define libname		libunique%{api}_%{major}
%define gi_name		libunique-gir%{api}
%define develname	libunique%{api}-devel

%define url_ver	%(echo %{version}|cut -d. -f1,2)

Name:		libunique3
Version:	3.0.2
Release:	alt1_14
Summary:	Single instance support for applications

Group:		System/Libraries
License:	LGPLv2+
URL:		http://www.gnome.org/~ebassi/source/
Source0:	https://download.gnome.org/sources/libunique/%{url_ver}/libunique-%{version}.tar.xz

BuildRequires:	gnome-doc-utils >= 0.3.2
BuildRequires:	libtool
BuildRequires:	glib2-devel >= 2.25.0
BuildRequires:	gtk3-demo libgtk+3 libgtk+3-devel libgtk+3-gir-devel
BuildRequires:	gtk-doc >= 1.11
BuildRequires:	gobject-introspection-devel
BuildRequires:	automake
BuildRequires:	autoconf
BuildRequires:	libtool
Source44: import.info

%description
Unique is a library for writing single instance applications, that is
applications that are run once and every further call to the same binary
either exits immediately or sends a command to the running instance.

This version of unique works with GTK+ 3.

#--------------------------------------------------------------------

%package -n %{libname}
Group:		System/Libraries
Summary:	Library for creating single instance applications
Obsoletes:	%{_lib}unique3_0 < 3.0.2

%description -n %{libname}
Unique is a library for creating single instance applications.

%files -n %{libname}
%doc AUTHORS ChangeLog COPYING README
%{_libdir}/libunique-%{api}.so.%{major}
%{_libdir}/libunique-%{api}.so.%{major}.*

#--------------------------------------------------------------------

%package -n %{gi_name}
Group:		System/Libraries
Summary:	GObject Introspection interface library for libunique
Requires:	%{libname} = %{version}-%{release}

%description -n %{gi_name}
GObject Introspection interface library for libunique.

%files -n %{gi_name}
%{_libdir}/girepository-1.0/Unique-%{api}.typelib

#--------------------------------------------------------------------

%package -n %{develname}
Summary:	Libraries and headers for unique3
Group:		Development/GNOME and GTK+
Provides:	%name-devel = %{version}-%{release}
Requires:	%{libname} = %{version}-%{release}
Requires:	%{gi_name} = %{version}-%{release}
Obsoletes:	%{_lib}unique3-devel < 3.0.2-13

%description -n %{develname}
Headers and libraries for unique3.

%files -n %{develname}
%doc %{_datadir}/gtk-doc
%{_includedir}/unique-3.0/
%{_libdir}/pkgconfig/*
%{_libdir}/lib*.so
%{_datadir}/gir-1.0/Unique-%{api}.gir

#--------------------------------------------------------------------

%prep
%setup -q -n libunique-%{version}

%build
# to recognize aarch64
autoreconf -vfi

%configure \
	--disable-gtk-doc \
	--disable-static \
	--enable-introspection=yes
%make_build

%install
%makeinstall_std

# we don't want these
find %{buildroot} -name '*.la' -delete


%changelog
