# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libtraceevent
Version: 1.8.4
Release: alt1
Summary: Library to parse raw trace event formats
License: GPL-2.0-only and LGPL-2.1-only
Group: System/Libraries
Url: https://git.kernel.org/pub/scm/libs/libtrace/libtraceevent.git/
Vcs: git://git.kernel.org/pub/scm/libs/libtrace/libtraceevent.git

Source: %name-%version.tar

Conflicts: trace-cmd-libs < 2.9.6-alt1
BuildRequires: asciidoc
BuildRequires: source-highlight
BuildRequires: xmlto
%{?!_without_check:%{?!_disable_check:
BuildRequires: CUnit-devel
}}

%description
%summary.

%package devel
Summary: %summary
Group: Development/C
Requires: %name = %EVR

%description devel
%summary.

%prep
%setup
sed -i 's/,-rpath=\$\$ORIGIN//' scripts/utils.mk

%build
%define optflags_lto %nil
%add_optflags %(getconf LFS_CFLAGS)
# Parallel build causing races on e2k.
%make CFLAGS="%optflags" prefix=%_prefix libdir=%_libdir V=1 all doc

%install
%makeinstall_std prefix=%_prefix libdir=%_libdir htmldir=%_defaultdocdir/%name doc-install V=1
rm %buildroot%_libdir/libtraceevent.a
# html documentation is duplicating man pages.
rm -rf %buildroot%_defaultdocdir/%name

%check
%make test V=1
utest/trace-utest

%files
%doc LICENSES/*
%_libdir/libtraceevent.so.*
%_libdir/traceevent

%files devel
%doc samples/*.c
%_includedir/traceevent
%_libdir/libtraceevent.so
%_libdir/pkgconfig/libtraceevent.pc
%_man3dir/*.3.*

%changelog
