Name: libtasn1
Version: 4.20.0
Release: alt2

%define soname 6

Summary: The ASN.1 library used in GNUTLS
Group: System/Libraries
License: LGPLv2.1+
URL: http://www.gnu.org/software/libtasn1/
Vcs: https://gitlab.com/gnutls/libtasn1
# git://git.altlinux.org/gears/l/libtasn1.git
Source: %name-%version.tar
Patch1: fix-for-werror.patch
Patch2: Enable-LFS-support.patch
Patch3: Fix-build-with-gcc11.patch
Patch4: Fix-build-with-gcc12.patch
Patch5: Fix-build-tests-with-gcc12.patch
Patch6: Fix-build-with-gcc13.patch
Patch7: Fix-tests-build-with-glibc-2.38.patch
Patch8: No-error-on-missing-variable-declarations.patch

BuildRequires: gtk-doc texinfo help2man

%description
This is GNU Libtasn1, a library that provides Abstract Syntax Notation
One (ASN.1, as specified by the X.680 ITU-T recommendation) parsing and
structures management, and Distinguished Encoding Rules (DER, as per
X.690) encoding and decoding functions.

This package contains libtasn1 runtime library.

%package devel
Summary: Files for development of applications which will use libtasn1
Group: Development/C
License: LGPLv2.1+
Requires: %name = %version-%release

%description devel
This is GNU Libtasn1, a library that provides Abstract Syntax Notation
One (ASN.1, as specified by the X.680 ITU-T recommendation) parsing and
structures management, and Distinguished Encoding Rules (DER, as per
X.690) encoding and decoding functions.

This package contains files for development of applications
which will use libtasn1.

%package utils
Summary: Some ASN.1 tools
Group: Text tools
License: GPLv3+
Requires: %name = %version-%release

%description utils
This is GNU Libtasn1, a library that provides Abstract Syntax Notation
One (ASN.1, as specified by the X.680 ITU-T recommendation) parsing and
structures management, and Distinguished Encoding Rules (DER, as per
X.690) encoding and decoding functions.

This package contains simple tools that can decode and encode ASN.1 data.

%package devel-doc
Summary: libtasn1 development documentation
Group: Development/Documentation
License: GFDL-1.3-or-later
Conflicts: %name-devel < %version
BuildArch: noarch

%description devel-doc
This is GNU Libtasn1, a library that provides Abstract Syntax Notation
One (ASN.1, as specified by the X.680 ITU-T recommendation) parsing and
structures management, and Distinguished Encoding Rules (DER, as per
X.690) encoding and decoding functions.

This package contains libtasn1 development documentation.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

%build
%autoreconf
%configure \
	--disable-static \
	--disable-silent-rules
touch doc/stamp_docs
# Don't add -Werror to CFLAGS before configure: too many configure tests
# fails and produces wrong results.
# Note: Don't add or enable -Werror for Elbrus.
%make_build \
%ifnarch %e2k
	CFLAGS="$CFLAGS -Werror" \
%endif
	%nil

%install
%makeinstall_std

%define docdir %_docdir/%name
mkdir -p %buildroot%docdir
install -pm644 AUTHORS NEWS README.md THANKS %buildroot%docdir/
ln -s %_licensedir/LGPL-2.1 %buildroot%docdir/COPYING.LIB
mkdir -p %buildroot%docdir/reference/html
install -pm644 doc/reference/html/* %buildroot%docdir/reference/html/

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
%make_build -k check

%files
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*
%dir %docdir
%docdir/[ACNRT]*

%files utils
%_bindir/asn1*
%_man1dir/*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files devel-doc
%_infodir/*
%_man3dir/*
%dir %docdir
%docdir/reference/

%changelog
