%define rname taglib
%define _K6link %_K6lib

Name: libtag
Version: 1.13.1
Release: alt5

Group: System/Libraries
Summary: TagLib, is well, a library for reading and editing audio meta data
License: (LGPL-2.1-only OR MPL-1.1) AND BSD-2-Clause AND LGPL-2.1-only
Url: http://taglib.github.io/

Provides: %rname = %version-%release

Source0: %rname-%version.tar
Source2: version-script.libtag

# upstream
Patch1: 0001-Fix-crash-with-invalid-WAV-files-1163-1164.patch
# SuSE
Patch2: taglib-1.8-ds-rusxmms-r2.patch
# ALT
Patch10: taglib-1.8-alt-versioning.patch

BuildRequires(pre): rpm-build-kf6
BuildRequires: gcc-c++ zlib-devel
#BuildRequires: librcc-devel
BuildRequires: doxygen graphviz cmake

%description
TagLib, is well, a library for reading and editing audio meta data,
commonly know as tags.
Some goals of TagLib:
	A clean, high level, C++ API to handling audio meta data.
	Support for at least ID3v1, ID3v2 and Ogg Vorbis comments.
	A generic, simple API for the most common tagging related functions.
	Binary compatibility between minor releases using the standard KDE/Qt
	techniques for C++ binary compatibility.
	Make the tagging framework extensible by library users; i.e. it will be
	possible for libarary users to implement additional ID3v2 frames,
	without modifying the TagLib source.
Because TagLib desires to be toolkit agnostic, in hope of being widely
adopted and the most flexible in licensing TagLib provides many of its
own toolkit classes; in fact the only external dependancy that TagLib has,
it a semi-sane STL implementation.

%package devel
Group: Development/C
Summary: Headers and static lib for taglib development
Provides: %rname-devel = %version-%release
Provides: pkgconfig(taglib) = %version
%description devel
Install this package if you want do compile applications using the libtag
library.


%prep
%setup -q -n %rname-%version
install -m0644 %SOURCE2 ./
%patch1 -p1
#%patch2 -p1
%patch10 -p1


%build
%K6cmake \
    -DINCLUDE_INSTALL_DIR=%_includedir \
    -DWITH_ASF:BOOL=ON \
    -DWITH_MP4:BOOL=ON \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DBUILD_TESTS:BOOL=OFF \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    #
%K6make
%K6make docs

%install
%K6install

#install alternative
sed -i -E 's|^Requires:[[:space:]]+%rname$|Requires: %rname-0|' %buildroot/%_libdir/pkgconfig/%{rname}_c.pc
mv %buildroot/%_libdir/pkgconfig/%rname{,-0}.pc
mv %buildroot/%_libdir/pkgconfig/%{rname}_c{,-0}.pc
install -d %buildroot/%_sysconfdir/alternatives/packages.d/
cat > %buildroot/%_sysconfdir/alternatives/packages.d/%name-devel <<__EOF__
%_libdir/pkgconfig/%rname.pc %_libdir/pkgconfig/%rname-0.pc %version
%_libdir/pkgconfig/%rname.pc %_libdir/pkgconfig/%{rname}_c-0.pc %version
__EOF__

%files
%doc AUTHORS NEWS
%_libdir/libtag.so.1
%_libdir/libtag.so.1.*
%_libdir/libtag_c.so.0
%_libdir/libtag_c.so.0.*

%files devel
%doc BUILD*/doc/html AUTHORS NEWS
%config %_sysconfdir/alternatives/packages.d/%name-devel
%_bindir/taglib-config
%_libdir/libtag.so
%_libdir/libtag_c.so
%_libdir/pkgconfig/taglib*.pc
%dir %_includedir/taglib/
%_includedir/taglib/*.h
%_includedir/taglib/*.tcc

%changelog
