# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ imake libXt-devel xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major   1
%define lib_name libsvg-cairo%{major}
%define devel_name libsvg-cairo-devel

Name:             libsvg-cairo
Summary:          A SVG library based on cairo
Version:          0.1.6
Release:          alt2_20
License:          BSD
Group:            System/Libraries
Source:           %{name}-%{version}.tar.bz2
URL:              http://cairographics.org/snapshots/
BuildRequires:    pkgconfig(libsvg)
BuildRequires:    pkgconfig(cairo)
BuildRequires:    pkgconfig(libjpeg)
Source44: import.info

%description
Libsvg-cairo provides the ability to render SVG content from files or
buffers. All rendering is performed using the cairo rendering library.

%package -n %{lib_name}
Summary:          A SVG library based on cairo
Group:            System/Libraries

%description -n %{lib_name}
Libsvg-cairo provides the ability to render SVG content from files or
buffers. All rendering is performed using the cairo rendering library.

%package -n %{devel_name}
Summary:          Libraries and include files for developing with libsvg
Group:            Development/C
Requires:         %{lib_name} = %{version}
Provides:         %{name}-devel = %{version}
Provides:         lib%{name}-devel = %{version}

%description -n %{devel_name}
This package provides the necessary development libraries and include
files to allow you to develop with libsvg-cairo.


%prep
%setup -q

# make autoreconf more happy
sed -i -e 's,LT_,_,g' configure.in

%build
# fix build on aarch64
autoreconf -vfi

export LIBS="-lm"
%configure --disable-static
%make_build

%install
%makeinstall_std
find $RPM_BUILD_ROOT -type f -name "*.la" -delete

%files -n %{lib_name}
%doc AUTHORS COPYING ChangeLog NEWS README
%{_libdir}/*.so.%{major}
%{_libdir}/*.so.%{major}.*

%files -n %{devel_name}
%{_libdir}/*.so
%{_includedir}/*
%{_libdir}/pkgconfig/libsvg-cairo.pc





%changelog
