Name:          libspectrum
Version:       1.4.5
Release:       alt0.1
Summary:       ZX Spectrum emulation shared library
License:       GPLv2
Group:         Emulators
Url:           https://sourceforge.net/projects/fuse-emulator/
Vcs:           https://git.code.sf.net/p/fuse-emulator/libspectrum
Packager:      ZX Spectrum Development Team <spectrum@packages.altlinux.org>

Source:        %name-%version.tar
# libbzip2: support for certain compressed files.
BuildRequires: bzlib-devel
# libaudiofile: support for loading from .wav files.
BuildRequires: libaudiofile-devel
# zlib: support for compressed RZX files.
BuildRequires: zlib-devel
# libgcrypt: the ability to digitally sign RZX files (note that Fuse requires version 1.1.42 or later).
BuildRequires: libgcrypt-devel
BuildRequires: glib2-devel
BuildRequires: libgpg-error-devel
BuildRequires: pkgconfig
BuildRequires: gcc-c++

%package       devel
Summary:       ZX Spectrum emulation library, header files
Group:         Emulators
Requires:      %name = %version-%release

%description
libspectrum is a library which is designed to make the input and
output of ZX Spectrum emulator files slightly easier than it would be
otherwise. It should hopefully compile and run on Unix-based systems,
Win32 and Mac OS X.

%description devel
libspectrum is a library which is designed to make the input and
output of ZX Spectrum emulator files slightly easier than it would be
otherwise. It should hopefully compile and run on Unix-based systems,
Win32 and Mac OS X.

This package contains header files for %name.

%prep
%setup
# for 1.4.4 TODO
sed "s/1.4.4/1.4.5/" -i ./configure.ac

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%files
%_libdir/%name.so.*
%_man3dir/*

%files devel
%_libdir/%name.so
%_libdir/pkgconfig/%name.pc
%_includedir/%name.h

%changelog
