%def_disable snapshot
%def_enable check

%define _name libsigc++
%define api_ver 2.0
%define ver_major 2.12
%def_disable docs

Name: %{_name}2
Version: %ver_major.1
Release: alt1

Summary: The Typesafe Callback Framework for C++
License: LGPL-2.1
Group: System/Libraries
Url: https://libsigcplusplus.github.io/libsigcplusplus/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Vcs: https://github.com/libsigcplusplus/libsigcplusplus.git
Source: %_name-%version.tar
%endif

Provides: libsigc++2.0 = %version-%release
Obsoletes: libsigc++2.0 < %version-%release

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ mm-common >= 1.0.5
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}

%description
libsigc++ implements a typesafe callback system for standard C++.
It allows you to define signals and to connect those signals to any
callback function, either global or a member function, regardless of
whether it is static or virtual.

%package devel
Summary: Development files for libsigc++ library
Group: Development/C++
Requires: %name = %version-%release
Provides: libsigc++2.0-devel = %version-%release
Obsoletes: libsigc++2.0-devel < %version-%release

%description devel
This package contains development files for the software development
using libsigc++ library.

%package doc
Summary: Documentation for libsigc++ library
Group: Books/Other
BuildArch: noarch
Provides: libsigc++2.0-doc = %version-%release
Obsoletes: libsigc++2.0-doc < %version-%release

%description doc
This package provides API documentation of libsigc++ library.

%prep
%setup -n %_name-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true \
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install
%define docdir %_docdir/%_name-%api_ver
%{?_disable_docs:mkdir -p %buildroot%docdir}
install -pm644 NEWS README* %buildroot%docdir/

%check
%__meson_test

%files
%_libdir/libsigc-%api_ver.so.*
%dir %docdir
%docdir/[NR]*

%files devel
%_libdir/libsigc-%api_ver.so
%_libdir/sigc++-%api_ver/
%_includedir/sigc++-%api_ver
%_pkgconfigdir/sigc++-%api_ver.pc

%files doc
%docdir
%exclude %docdir/[ANR]*
%{?_enable_docs:%_datadir/devhelp/books/*}


%changelog
