Packager: Repocop Q. A. Robot <repocop@altlinux.org>
%define apiver 1.2
%define dir_name sigc++-%apiver

Name: libsigc++%apiver
Version: 1.2.7
Release: alt3

%def_disable static

Summary: The Typesafe Signal Framework for C++
License: LGPL
Group: System/Libraries
Url: http://libsigc.sourceforge.net/

#Provides: libsigc++ = %version

Prefix: %prefix

Source: http://download.sourceforge.net/libsigc/libsigc++-%version.tar.bz2

BuildRequires: gcc-c++ libstdc++-devel xsltproc docbook-style-xsl

%description
This library implements a full callback system for use in widget libraries,
abstract interfaces, and general programming. Originally part of the Gtk--
widget set, libsigc++ is now a seperate library to provide for more general
use. It is the most complete library of its kind with the ablity to connect
an abstract callback to a class method, function, or function object. It
contains adaptor classes for connection of dissimilar callbacks and has an
ease of use unmatched by other C++ callback libraries.

Package gtkmm, which is a C++ binding to the gtk+ library, uses libsigc++.

%package devel
Summary: Development tools for the Typesafe Signal Framework for C++
Group: Development/C++
Requires: %name = %version-%release
#Provides: libsigc++-devel = %version

%description devel
This package contains files needed for development with libsigc++.

%if_enabled static
%package devel-static
Summary: Static library for the Typesafe Signal Framework for C++
Group: Development/C++
Requires: %name-devel = %version-%release
#Provides: libsigc++-devel-static = %version

%description devel-static
This package contains static library needed for development
of statically linked software with libsigc++.
%endif	# enabled static

%package examples
Summary: Examples and test suite for the Typesafe Signal Framework for C++
Group: Development/C++
Requires: %name-devel = %version-%release

%description examples
This package contains source code of example and test
programs for libsigc++.

%prep
%setup -q -n libsigc++-%version

%build
# the 1.2.5 tarball is so fresh it's ahead of my time
touch configure
%undefine __libtoolize
%configure %{subst_enable static}

%make_build
%make check

%make -C doc/manual DOCBOOK_STYLESHEET=%_datadir/xml/docbook/xsl-stylesheets/html/chunk.xsl

%install
%define docdir %_docdir/libsigc++-%version

mkdir -p -m 755 $RPM_BUILD_ROOT{%_includedir,%_libdir}/%dir_name
%makeinstall

mkdir -p -m 755 $RPM_BUILD_ROOT%docdir
cp -a examples tests $RPM_BUILD_ROOT%docdir
find $RPM_BUILD_ROOT%docdir -type d \( -name .libs -o -name .deps \) -print0 |
	xargs -r0 rm -rf
find $RPM_BUILD_ROOT%docdir -type f -print0 |xargs -r0 file |
	egrep '(relocatable|executable|shell script)' |cut -d: -f1 |xargs -r rm -f
find $RPM_BUILD_ROOT%docdir -type f -name 'Makefile.*' -print0 |
	xargs -r0 rm -f
cp -pf scripts/examples.Makefile \
	$RPM_BUILD_ROOT%docdir/examples/Makefile
cp -pf scripts/tests.Makefile \
	$RPM_BUILD_ROOT%docdir/tests/Makefile

echo "%%dir %docdir" >docs.list
for f in AUTHORS FEATURES README IDEAS ChangeLog NEWS TODO \
         doc/{API,FAQ,UML,conventions,diagrams,marshal,powerusers,requirements,signals}; do
    destname=`basename $f`
    install -m 644 $f $RPM_BUILD_ROOT%docdir/$destname
    echo "%docdir/$destname" >>docs.list
done
cp -a doc/manual/html $RPM_BUILD_ROOT%docdir
echo "%docdir/html" >>docs.list

%files
%_libdir/*.so.*

%files devel -f docs.list
%_libdir/pkgconfig/*
%_libdir/*.so
%dir %_libdir/%dir_name
%_libdir/%dir_name/include
%_includedir/%dir_name

%if_enabled static
%files devel-static
%_libdir/*.a
%endif	# enabled static

%files examples
%dir %docdir
%docdir/examples
%docdir/tests

%changelog
