Name: libshout2
Version: 2.4.6
Release: alt2

Summary: libshout - icecast source streaming library
Group: System/Libraries
License: LGPLv2+
Url: http://www.icecast.org/
# http://downloads.us.xiph.org/releases/libshout/libshout-%version.tar.gz
Source: libshout-%version.tar
Patch: %name-%version-alt-shout2.patch

%def_disable static

%if_enabled static
BuildRequires: glibc-devel-static
%endif
BuildRequires: libogg-devel libvorbis-devel libtheora-devel libspeex-devel libssl-devel

%description
Libshout is a library for communicating with and sending data to an
icecast server. It handles the socket connection, the timing of the
data, and prevents most bad data from getting to the icecast server.

%package devel
Summary: icecast2 source streaming library development package
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains development library and header files needed for
developing applications that send data to an icecast2 server.

%package devel-static
Summary: icecast2 static library
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package contains static version of libshout2 library.

%prep
%setup -n libshout-%version
%patch -p1

%build
%autoreconf
%configure \
	--includedir=%_includedir/shout2 \
	--oldincludedir=%_includedir/shout2 \
	%{subst_enable static}

%make_build docdir=%_docdir/libshout-%version

%install
%makeinstall_std docdir=%_docdir/libshout-%version

%files
%_libdir/*.so.*
%_docdir/libshout-%version

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
