Name: librtmidi
Version: 6.0.0
Release: alt1

Summary: Library for realtime MIDI input/output
License: MIT
Group: System/Libraries
Url: https://github.com/thestk/rtmidi

Source: %name-%version-%release.tar

BuildRequires: gcc-c++
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(jack)

%package -n librtmidi7
Summary: RtMidi shared library
Group: System/Libraries

%package devel
Summary: Development headers and libraries for RtMidi
Group: Development/C

%define desc\
RtMidi is a set of C++ classes (RtMidiIn and RtMidiOut) that provides a common\
API (Application Programming Interface) for realtime MIDI input/output across \
Linux (ALSA & Jack), Macintosh OS X, Windows (Multimedia Library), and SGI \
operating systems. RtMidi significantly simplifies the process of interacting \
with computer MIDI hardware and software. It was designed with the following \
goals:\
* object oriented C++ design\
* simple, common API across all supported platforms\
* only two header files and one source file for easy inclusion in programming \
  projects\
* MIDI device enumeration

%description %desc

%description -n librtmidi7 %desc
This package contains the shared library.

%description devel %desc
Development headers and libraries for rtmidi.

%prep
%setup

%build
%autoreconf
%configure --disable-static --with-alsa --with-jack

%install
%make_install DESTDIR=%buildroot install

%files -n librtmidi7
%_libdir/librtmidi.so.*

%files -n librtmidi-devel
%doc README.md doc/release.txt
%_includedir/rtmidi
%_libdir/librtmidi.so
%_pkgconfigdir/rtmidi.pc

%changelog
