%define oldname re2
Name: libre2_10
Version: 20230301
Release: alt2
Summary: C++ fast alternative to backtracking RE engines
Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/google/re2/
Source0: %name-%version.tar
BuildRequires: gcc-c++

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake ctest

%description
RE2 is a C++ library providing a fast, safe, thread-friendly alternative to
backtracking regular expression engines like those used in PCRE, Perl, and
Python.

Backtracking engines are typically full of features and convenient syntactic
sugar but can be forced into taking exponential amounts of time on even small
inputs.

In contrast, RE2 uses automata theory to guarantee that regular expression
searches run in time linear in the size of the input, at the expense of some
missing features (e.g back references and generalized assertions).

%package -n libre2
Summary: C++ fast alternative to backtracking RE engines
Group: System/Libraries

%description -n libre2
RE2 is a C++ library providing a fast, safe, thread-friendly alternative to
backtracking regular expression engines like those used in PCRE, Perl, and
Python.

%prep
%setup

%build
%cmake \
  -DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
  -DCMAKE_COLOR_MAKEFILE:BOOL=OFF \
  -DBUILD_SHARED_LIBS:BOOL=ON
%cmake_build

%install
%cmake_install

# Suppress the static library
find %buildroot -name 'libre2.a' -delete

%check
ctest --test-dir %_cmake__builddir --output-on-failure --force-new-ctest-process %_smp_mflags

%files -n libre2
%doc LICENSE
%doc AUTHORS CONTRIBUTORS README
%_libdir/libre2.so.*

%changelog
