%define _unpackaged_files_terminate_build 1

%define pypi_name google-re2
%define mod_name re2

%define oldname re2
%define soname 11
Name: libre2
Version: 20240702
Release: alt2
Summary: C++ fast alternative to backtracking RE engines
Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/google/re2/
Source0: %name-%version.tar
BuildRequires: gcc-c++ libabseil-cpp-devel
Provides: re2 = %EVR

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ cmake ctest
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pybind11

%description
RE2 is a C++ library providing a fast, safe, thread-friendly alternative to
backtracking regular expression engines like those used in PCRE, Perl, and
Python.

Backtracking engines are typically full of features and convenient syntactic
sugar but can be forced into taking exponential amounts of time on even small
inputs.

In contrast, RE2 uses automata theory to guarantee that regular expression
searches run in time linear in the size of the input, at the expense of some
missing features (e.g back references and generalized assertions).

%package -n %{name}_%soname
Summary: C++ fast alternative to backtracking RE engines
Group: System/Libraries

%description -n %{name}_%soname
RE2 is a C++ library providing a fast, safe, thread-friendly alternative to
backtracking regular expression engines like those used in PCRE, Perl, and
Python.

%package devel
Summary: C++ header files and library symbolic links for re2
Group: Development/Other
Requires: %{name}_%soname = %EVR
Provides: re2-devel = %EVR

%description devel
This package contains the C++ header files and symbolic links to the shared
libraries for %oldname. If you would like to develop programs using %oldname,
you will need to install %name-devel.

%package -n python3-module-%pypi_name
Version: 1.1.%{version %name}
Summary: RE2 Python bindings
Group: Development/Python3

%description -n python3-module-%pypi_name
A drop-in replacement for the re module.

It uses RE2 under the hood, of course, so various PCRE features
(e.g. backreferences, look-around assertions) are not supported.

%prep
%setup
%ifarch %e2k
%add_optflags -std=c++17
%endif

%build
%cmake \
  -DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
  -DCMAKE_COLOR_MAKEFILE:BOOL=OFF \
  -DBUILD_SHARED_LIBS:BOOL=ON
%cmake_build

cd python
cat >> setup.cfg << EOF
[build_ext]
include_dirs = ..
library_dirs = ../%_cmake__builddir
EOF
%pyproject_build

%install
%cmake_install

# Suppress the static library
find %buildroot -name '%name.a' -delete

cd python
%pyproject_install

%check
ctest --test-dir %_cmake__builddir --output-on-failure --force-new-ctest-process %_smp_mflags

%files -n %{name}_%soname
%doc LICENSE
%doc README
%_libdir/%name.so.%soname
%_libdir/%name.so.%soname.*


%files devel
%_includedir/%oldname
%_libdir/%name.so
%_pkgconfigdir/%oldname.pc
%_libdir/cmake/%oldname


%files -n python3-module-%pypi_name
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pep427_name %pypi_name}-%{version python3-module-%pypi_name}.dist-info/

%changelog
