%def_with check

# mklove configure script can't process it
%define _configure_gettext %nil

# lto breaks crc32 detection in configure script
# See https://github.com/edenhill/librdkafka/issues/2426
%ifnarch x86_64
%define optflags_lto %nil
%endif

Name: librdkafka
Version: 2.6.1
Release: alt1

Summary: the Apache Kafka C/C++ client library

License: BSD-2-Clause
Group: Development/C++
Url: https://github.com/edenhill/librdkafka

Packager: Pavel Vainerman <pv@altlinux.ru>

Source: %name-%version.tar
Source1: rdkafka.pc

BuildRequires: cmake gcc-c++ libssl-devel liblz4-devel libxxhash-devel libsasl2-devel

%if_with check
BuildRequires: ctest
%endif

%description
librdkafka is a C library implementation of the Apache Kafka protocol, containing
both Producer and Consumer support. It was designed with message delivery
reliability and high performance in mind, current figures exceed 1 million
msgs/second for the producer and 3 million msgs/second for the consumer.

%package devel
Group: Development/C++
Summary: the Apache Kafka C/C++ client library
Requires: %name = %version-%release

%description devel
librdkafka is a C library implementation of the Apache Kafka protocol, containing
both Producer and Consumer support. It was designed with message delivery
reliability and high performance in mind, current figures exceed 1 million
msgs/second for the producer and 3 million msgs/second for the consumer.

%prep
%setup

%build
%configure
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_libdir/pkgconfig
cp %SOURCE1 %buildroot%_libdir/pkgconfig/
sed -i 's|@VERSION@|%version|g' %buildroot%_libdir/pkgconfig/*.pc

rm -f %buildroot%_libdir/*.a
rm -f %buildroot%_datadir/licenses/librdkafka/LICENSES.txt

%check
%make_build check

%files
%doc LICENSE README.md
%_docdir/%name
%_libdir/*.so.*

%files devel
%_libdir/*.so
%dir %_includedir/%name
%_includedir/%name/*.h
%_libdir/pkgconfig/*.pc

%changelog
