%def_disable static
%def_without doc
%define abiversion 11

Name: libraw1394
Version: 2.1.2
Release: alt1

Summary: FireWire interface library

License: GPL/LGPL
Group: System/Libraries
Url: http://ieee1394.wiki.kernel.org

Source: %name-%version.tar.bz2
Patch: libraw1394-0.10.0-alt-makefile.patch
Patch1: libraw1394-0.10.0-alt-doc.patch

%if_enabled static
BuildPreReq: glibc-devel-static
%endif

%if_with doc
# manually removed: gcc-g77 libg2c-devel
# Automatically added by buildreq on Mon Jul 06 2009
BuildRequires: docbook-utils
%endif

%description
libraw1394 is the only supported interface to the kernel side raw1394 of
the Linux IEEE-1394 subsystem, which provides direct access to the connected
1394 buses to user space.  Through libraw1394/raw1394, applications can
directly send to and receive from other nodes without requiring a kernel driver
for the protocol in question.

The reason for making a library the interface to the kernel is to avoid
a program dependancy on the kernel version, which would hinder development and
optimization of raw1394.  If development changed the protocol and made it
incompatible with previous versions only the libraw1394 has to be upgraded to
match the kernel version (instead of all applications).

%package -n %name-%abiversion
Summary: FireWire interface library
Group: System/Libraries

%description -n %name-%abiversion
libraw1394 is the only supported interface to the kernel side raw1394 of
the Linux IEEE-1394 subsystem, which provides direct access to the connected
1394 buses to user space.  Through libraw1394/raw1394, applications can
directly send to and receive from other nodes without requiring a kernel driver
for the protocol in question.

The reason for making a library the interface to the kernel is to avoid
a program dependancy on the kernel version, which would hinder development and
optimization of raw1394.  If development changed the protocol and made it
incompatible with previous versions only the libraw1394 has to be upgraded to
match the kernel version (instead of all applications).

%package tools
Summary: Development and include files for libraw1394
Group: System/Kernel and hardware
Requires: %name-%abiversion = %version-%release

%description tools
libraw1394 is the only supported interface to the kernel side raw1394 of
the Linux IEEE-1394 subsystem, which provides direct access to the connected
1394 buses to user space.  Through libraw1394/raw1394, applications can
directly send to and receive from other nodes without requiring a kernel driver
for the protocol in question.

This package provides tools to dump, send, format IEEE 1394
isochronous channel packets and test %name basic functionality.

%package devel
Summary: Development and include files for libraw1394
Group: Development/C
Requires: %name-%abiversion = %version-%release

%description devel
libraw1394 is the only supported interface to the kernel side raw1394 of
the Linux IEEE-1394 subsystem, which provides direct access to the connected
1394 buses to user space.  Through libraw1394/raw1394, applications can
directly send to and receive from other nodes without requiring a kernel driver
for the protocol in question.

This package contains the header files for libraw1394 development

%package devel-static
Summary: Development components for libraw1394
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
libraw1394 is the only supported interface to the kernel side raw1394 of
the Linux IEEE-1394 subsystem, which provides direct access to the connected
1394 buses to user space.  Through libraw1394/raw1394, applications can
directly send to and receive from other nodes without requiring a kernel driver
for the protocol in question.

This package contains the static libraries.

%prep
%setup

%build
%configure \
    %{subst_enable static}

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build
%if_with doc
make -C doc htmldoc || echo "Fix me if possible"
%endif

%install
%makeinstall_std

%if_with doc
mv doc/%name doc/html
%endif

# remove non-packaged files
rm -f %buildroot%_libdir/*.la

%files -n %name-%abiversion
%_libdir/*.so.*
%doc README NEWS AUTHORS

%files devel
%_includedir/%name/
%_libdir/*.so
%_pkgconfigdir/*
%if_with doc
%doc doc/html
%endif

%files tools
%_bindir/*
%_man1dir/*
%_man5dir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
