%global pre beta1

# This package requires libspatialite 4.2 and solves the tasks librasterlite
# and gaiagraphics solved in the past. It is not a drop-in replacement for either.
Name:          librasterlite2
Version:       1.1.0
Release:       alt1.1
Summary:       Stores and retrieves huge raster coverages using a SpatiaLite DBMS
License:       MPLv1.1 or GPLv2+ or LGPLv2+
Group: System/Libraries
URL:           https://www.gaia-gis.it/fossil/librasterlite2
Source0:       http://www.gaia-gis.it/gaia-sins/%{name}-sources/%{name}-%{version}%{?pre:-%pre}.tar.gz

BuildRequires: gcc
BuildRequires: libcairo-devel
BuildRequires: libCharLS-devel
BuildRequires: libgif-devel
BuildRequires: libcurl-devel
BuildRequires: libgeotiff-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libspatialite-devel
BuildRequires: libwebp-devel
BuildRequires: libxml2-devel
BuildRequires: libzstd-devel
BuildRequires: liblz4-devel
BuildRequires: libminizip-devel
BuildRequires: libopenjpeg2.0-devel
BuildRequires: libproj-devel
BuildRequires: libsqlite3-devel libpixman-devel
#BuildRequires: libxz-devel
BuildRequires: zlib-devel liblzma-devel xz
BuildRequires: make

%description
librasterlite2 is a library that stores and retrieves huge raster coverages
using a SpatiaLite DBMS.


%package devel
Summary:  Development libraries and headers for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}
Group: System/Libraries

%description devel
This package contains libraries and header files for
developing applications that use %{name}.


%package tools
Summary:  Tools for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}
License:  GPLv3+
Group: System/Libraries

%description tools
The %{name}-tools package contains l2tool and rwmslite.
rl2tool is a CLI tool to create and manage rasterlite2 coverages.
wmslite is a simple WMS server (Web Map Service) based on librasterlite2.


%prep
%setup -n %{name}-%{version}%{?pre:-%pre}


%build
%configure --disable-static
%make_build


%install
#make_install
%makeinstall_std

# Delete undesired libtool archives
rm -f %{buildroot}/%{_libdir}/%{name}.la
rm -f %{buildroot}/%{_libdir}/mod_rasterlite2.la

# Delete soname symlink for the sqlite extension
#rm -f %{buildroot}/%{_libdir}/mod_rasterlite2.so.*




%files
%doc AUTHORS
%{_libdir}/%{name}.so.*
# The symlink must be present to allow loading the extension
# https://groups.google.com/forum/#!topic/spatialite-users/zkGP-gPByXk
%{_libdir}/mod_rasterlite2.so*

%files devel
%doc examples/*.c
%{_includedir}/rasterlite2
%{_libdir}/%{name}.so
%{_libdir}/pkgconfig/rasterlite2.pc

%files tools
%{_bindir}/rl2sniff
%{_bindir}/rl2tool
%{_bindir}/wmslite


%changelog
