BuildRequires: chrpath
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gtkdocize gcc-c++
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
%define oldname phat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: A collection of GTK+ widgets useful for audio applications
Name:          libphat
Version:       0.4.1
Release:       alt2_22
License:       GPLv2+
URL:           http://phat.berlios.de/
Source0:       http://download.berlios.de/%{oldname}/%{oldname}-%{version}.tar.gz
# Remove unused variables - to be submitted upstream
Patch0:        phat-unused-but-set-variable.patch
Patch1:        phat-fix-fsf-address.patch
Patch2:        phat-gdk-unref.patch

BuildRequires:  gcc
BuildRequires: libgtk+2-devel
BuildRequires: libgnomecanvas-devel
Source44: import.info
Provides: phat = %{version}-%{release}

%description
PHAT is a collection of GTK+ widgets geared toward pro-audio apps. The
goal is to eliminate duplication of effort and provide some
standardization (well, at least for GTK+ apps).

%package devel
Group: Development/Other
Summary:       Header files for PHAT 
Requires:      %{name} = %{version}-%{release}
Provides: phat-devel = %{version}-%{release}

%description devel
Header files and additional libraries used for developing applications
with the PHAT Audio Toolkit.

%package docs
Group: Development/Other
Summary:       Documentation for PHAT 
BuildArch: noarch
Provides: phat-docs = %{version}-%{release}

%description docs
Documentation for the PHAT Audio Toolkit.

%prep
%setup -n %{oldname}-%{version} -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

sed -i s,-Werror,, configure.ac configure

%build
%configure --enable-debug --disable-static
%make_build 

%install
make DESTDIR=%{buildroot} install

rm %{buildroot}%{_libdir}/libphat.*a
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done



%files
%doc AUTHORS ChangeLog COPYING NEWS README TODO
%{_bindir}/phat*
%{_libdir}/libphat.so.*
%{_datadir}/%{oldname}

%files devel
%{_libdir}/libphat.so
%{_libdir}/pkgconfig/%{oldname}.pc
%{_includedir}/%{oldname}

%files docs
%{_datadir}/gtk-doc/html/%{oldname}

%changelog
