%define _unpackaged_files_terminate_build 1

Name: libpcap
Version: 1.10.5
Release: alt1
Epoch: 2

# Default optional switches
%def_enable dbus
%def_enable bluetooth
%def_enable usb
%def_enable yydebug
%def_enable packetring
%def_disable static

Summary: A system-independent interface for user-level packet capture
License: BSD
Group: System/Libraries
Url: http://www.tcpdump.org

# git://git.altlinux.org/gears/l/libpcap
Source: %name-%version-%release.tar

%define libname libpcap0.8

BuildRequires: flex
# bluetooth sniffing support
%{?_enable_bluetooth:BuildRequires: libbluez-devel}
# D-Bus support
%{?_enable_dbus:BuildRequires: libdbus-devel}

%package -n %libname
Summary: A system-independent interface for user-level packet capture
Group: System/Libraries
Provides: %name = %epoch:%version-%release
Obsoletes: %name

%package devel
Summary: Development environment for the packet capture library
Group: Development/C
Requires: %libname = %epoch:%version-%release

%if_enabled static
%package devel-static
Summary: Static packet capture library
Group: Development/C
Requires: %name-devel = %epoch:%version-%release
%endif

%description
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

%description -n %libname
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

%description devel
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

This package contains development files needed to develop libpcap-based
applications such as tcpdump, etc.

%if_enabled static
%description devel-static
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

This package contains the static pcap library needed to develop
statically linked libpcap-based applications.
%endif

%prep
%setup -n %name-%version-%release

%build
export PKG_CONFIG_PATH="$(pwd)/pkgconfig"
mkdir -p pkgconfig
sed '/^Requires.* libsystemd/d' %_pkgconfigdir/dbus-1.pc > pkgconfig/dbus-1.pc

export V_RPATH_OPT=
%autoreconf
%configure \
	%{subst_enable dbus} \
	%{subst_enable bluetooth} \
	%{subst_enable usb} \
	%{subst_enable yydebug} \
	%{subst_enable packetring} \

%make_build shared pcap-config libpcap.pc %{?_enable_shared:libpcap.a}

%install
%make_install DESTDIR=%buildroot \
	install-bin install-include install-shared %{?_enable_shared:install-archive}

%define _customdocdir %_docdir/libpcap-%version

%files -n %libname
%_libdir/*.so.*
%_man7dir/*
%doc CHANGES CREDITS LICENSE README.md TODO

%files devel
%_bindir/*
%_libdir/*.so
%_includedir/*
%_mandir/man[135]/*
%_libdir/pkgconfig/libpcap.pc

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
