%def_disable snapshot
%define ver_major 1.10
%define beta %nil
%define api_ver 1
%define namespace Panel
%define xdg_name org.gnome.Panel%api_ver

%def_enable introspection
%def_enable vala
%def_enable docs
%def_enable examples
%def_disable check

Name: libpanel
Version: %ver_major.3
Release: alt1%beta

Summary: Library with GTK4 widgets for IDE-like applications
Group: System/Libraries
License: LGPL-3.0-or-later
Url: https://gitlab.gnome.org/GNOME/libpanel

Vcs: https://gitlab.gnome.org/GNOME/libpanel.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
#Source: %url/-/archive/%version/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

%define meson_ver 0.63
%define glib_ver 2.80
%define gtk_ver 4.16
%define adwaita_ver 1.6

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= %meson_ver
BuildRequires: pkgconfig(gio-2.0) >= %glib_ver
BuildRequires: pkgconfig(gtk4) >= %gtk_ver  pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libfribidi-devel
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: pkgconfig(gobject-introspection-1.0) gir(Gtk) = 4.0 gir(Adw) = 1}
%{?_enable_vala:BuildRequires(pre): rpm-build-vala
BuildRequires: vala-tools}
%{?_enable_docs:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: xvfb-run librsvg}

%description
%name is a collection of GTK widgets for IDE-like applications targeting
GNOME using GTK4 and libadwaita.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the %name library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %EVR

%description devel-doc
This package contains development documentation for %name library.

%package demo
Summary: %name widgets demonstration programs
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description demo
This package contains a program, along with its source code, that
demonstrates %name variety of all its widgets.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_feature docs docs} \
    %{subst_enable_meson_bool examples install-examples}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
xvfb-run -s -noreset %__meson_test

%files -f %name.lang
%_libdir/%name-%api_ver.so.*
%_iconsdir/hicolor/*/actions/panel-*.svg
%doc README* NEWS

%files devel
%_includedir/%name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.*}

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%if_enabled docs
%files devel-doc
%_datadir/doc/panel-1.0/
%endif

%if_enabled examples
%files demo
%_bindir/%name-example
%endif

%changelog
