%define _unpackaged_files_terminate_build 1
%define engines_dir %(pkg-config --variable=enginesdir --silence-errors libcrypto 2>/dev/null || echo unknown)
%define modules_dir %(pkg-config --variable=modulesdir --silence-errors libcrypto 2>/dev/null || echo unknown)
%def_enable check

Name: libp11
Version: 0.4.16
Release: alt1
Summary: Library for using PKCS#11 modules
License: LGPL-2.1-or-later
Group: System/Libraries
Url: https://github.com/OpenSC/libp11/wiki
Vcs: https://github.com/OpenSC/libp11.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch
Provides: openssl-engine_pkcs11 = %version-%release
Obsoletes: openssl-engine_pkcs11 < %version-%release

BuildRequires: pkgconfig(p11-kit-1)
BuildRequires: libssl-devel >= 0.9.8

%if_enabled check
BuildRequires: /proc
BuildRequires: openssl
BuildRequires: softhsm
BuildRequires: opensc
%endif

%description
Libp11 is a library implementing a small layer on top of PKCS#11 API
to make using PKCS#11 implementations easier.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release
Requires: libssl-devel

%description devel
Development files for %name.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
   --disable-static \

%make_build

%install
%makeinstall_std

# Cleanup
rm %buildroot%_libdir/*.la
rm %buildroot%engines_dir/*.la
rm %buildroot%modules_dir/*.la
rm -r %buildroot%_docdir/%name

%check
%make VERBOSE=1 check

%files
%doc NEWS README.md
%_libdir/libp11.so.*
%engines_dir/libpkcs11.so
%engines_dir/pkcs11.so
%modules_dir/libpkcs11.so
%modules_dir/pkcs11prov.so

%files devel
%_libdir/libp11.so
%_pkgconfigdir/libp11.pc
%_includedir/*

%changelog
