Name: liboping
Version: 1.10.0
Release: alt2

Summary: Liboping library
License: LGPLv2.1
Group: System/Libraries

Url: https://github.com/octo/liboping
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: /usr/bin/pod2man

%description
liboping is a C library to generate ICMP echo requests, better known
as "ping packets". It is intended for use in network monitoring
applications or applications that would otherwise need to fork
ping(1) frequently.

liboping was inspired by ping, libping (homepage vanished) and fping:
it differs from these existing solutions in that it can `ping' multiple
hosts in parallel using IPv4 or IPv6 transparently. Other design
principles were an object oriented interface, simplicity and
extensibility: Is simple because there are only a few interface
functions and no external dependencies. It's extensible since all
(internal) data is kept in "opaque data types", so the storage may
change or be extended without applications noticing it.

%package -n oping
Summary: oping ICMP query tool
Group: Networking/Other

%description -n oping
Sample application, which demonstrates the liboping's abilities.
It is like ping, ping6, and fping rolled into one.

%package devel
Summary: Header files for liboping library
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files for liboping library.


%prep
%setup
%patch0 -p1

%build
%autoreconf
%configure --with-perl-bindings=no \
	   --disable-static \
#
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog README
%_libdir/*.so.*

%files -n oping
%_bindir/oping
%_man8dir/*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*

# TODO:
# - package perl modules
# - scrap gear repo, redo with git://git.verplant.org/liboping.git

%changelog
