%def_disable snapshot
%define _name openshot

%define ver_major 0.4
%define api_ver 24

%def_enable python
%def_enable opencv
%def_disable doc
#99%% tests passed, 1 tests failed out of 132
%def_disable check

Name: lib%_name
Version: %ver_major.0
Release: alt1

Summary: OpenShot Video Library
Group: System/Libraries
License: GPL-3.0-or-later
Url: https://launchpad.net/%name

Vcs: https://github.com/OpenShot/libopenshot.git

%if_disabled snapshot
#Source: %url/%ver_major/%version/+download/%name-%version.tar.gz
Source: https://github.com/OpenShot/%name/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

# based on http://github.com/EntityFX/libopenshot
Patch2000: libopenshot-0.3.0-entityfx-e2k.patch

BuildRequires(pre): rpm-macros-cmake rpm-build-python3
BuildRequires: /proc cmake gcc-c++
BuildRequires: %name-audio-devel >= %ver_major
BuildRequires: python3(setuptools._distutils)
BuildRequires: libgomp-devel libunittest-cpp-devel jsoncpp-devel
BuildRequires: libalsa-devel qt5-multimedia-devel qt5-svg-devel libzeromq-cpp-devel
BuildRequires: libImageMagick-devel zlib-devel
BuildRequires: libavcodec-devel libavformat-devel libavutil-devel
BuildRequires: libswresample-devel libswscale-devel
BuildRequires: libavdevice-devel libpostproc-devel
BuildRequires: libbabl-devel
# https://github.com/RazrFalcon/resvg
# BuildRequires: libresvg-devel
%{?_enable_opencv:BuildRequires: boost-devel libopencv-devel libprotobuf-devel %_bindir/protoc}
%{?_enable_python:BuildRequires: python3-devel python3-module-zmq swig}
%{?_enable_check:BuildRequires: ctest ImageMagick-tools
BuildRequires: catch2-devel}

%description
libopenshot is an open-source, cross-platform C++ library dedicated to
delivering high quality video editing, animation, and playback solutions
to the world. This is the same library which powers OpenShot Video Editor
(version 2.0+) and it could power your next video editing application!
C++, Python, and Ruby are fully supported, and other languages can be
added if requested.

%package devel
Summary: OpenShot Video Library development package
Group: Development/C++
Requires: %name = %EVR

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%package -n python3-module-%_name
Summary: Python3 bindings for OpenShot Video Library
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-%_name
This package provides Python3 bindings for OpenShot Video Library.

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%build
%add_optflags %(getconf LFS_CFLAGS) -DNDEBUG
%ifarch %e2k
%add_optflags -DJUCE_NO_INLINE_ASM=1 -DJUCE_USE_SIMD=0
%endif
%cmake  -DUSE_SYSTEM_JSONCPP:BOOL=ON \
	-DMAGICKCORE_HDRI_ENABLE:BOOL=ON \
	-DMAGICKCORE_QUANTUM_DEPTH=16 \
	%{?_enable_python:-DENABLE_PYTHON=TRUE} \
	%{?_enable_opencv:-DENABLE_OPENCV=TRUE} \
	%{?_enable_check:-DENABLE_TESTS=TRUE}
%nil
%cmake_build

%install
%cmake_install

%check
%cmake_build -t test

%files
%_libdir/%name.so.*
%doc AUTHORS README*

%files devel
%_includedir/%name/
%_libdir/%name.so

%files -n python3-module-%_name
%python3_sitelibdir/*

%changelog
