%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

# TODO: dependency on Field3D

# TODO: build and run tests

%define oname openimageio
%define soname 3.0

%def_without bootstrap

Name:           lib%oname
Version:        3.0.11.0
Release:        alt1
Summary:        Library for reading and writing images
Group:          System/Libraries

License:        BSD-3-Clause and Apache-2.0
URL:            https://sites.google.com/site/openimageio/home
VCS: https://github.com/AcademySoftwareFoundation/OpenImageIO
Source0:        %name-%version.tar

# Images for test suite
#Source1:        oiio-images.tar.gz

Source2: %oname.watch

Patch2000: %oname-e2k.patch

BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-devel
BuildRequires:  cmake gcc-c++
BuildRequires:  txt2man
BuildRequires:  qt6-base-devel
BuildRequires:  boost-devel boost-python3-devel boost-filesystem-devel boost-asio-devel
BuildRequires:  libGLEW-devel
BuildRequires:  openexr-devel imath-devel
BuildRequires:  libpng-devel libtiff-devel libjpeg-devel libturbojpeg-devel libopenjpeg2.0-devel
%if_without bootstrap
%ifnarch %ix86
BuildRequires:  openshadinglanguage-devel
%endif
%endif
BuildRequires:  libgif-devel
BuildRequires:  libwebp-devel >= 1.6.0-alt1.1
BuildRequires:  libhdf5-devel
BuildRequires:  zlib-devel
BuildRequires:  libjasper-devel
BuildRequires:  libpugixml-devel
BuildRequires:  libraw-devel
BuildRequires:  librobin-map-devel
BuildRequires:  pybind11-devel
BuildRequires:  libsquish-devel
BuildRequires:  libultrahdr-devel
BuildRequires:  bzip2-devel
BuildRequires:  freetype2-devel
BuildRequires:  libfmt-devel
BuildRequires:  openvdb-devel
BuildRequires:  libjxl-devel
%ifnarch %e2k
BuildRequires:  libdcmtk-devel
%endif
BuildRequires:  libopencv-devel
BuildRequires:  libavcodec-devel libavformat-devel libswscale-devel
BuildRequires:  libheif-devel libPtex-devel

# WARNING: OpenColorIO and OpenImageIO are cross dependent.
# If an ABI incompatible update is done in one, the other also needs to be
# rebuilt.
BuildRequires:  libopencolorio2.0-devel

%description
OpenImageIO is a library for reading and writing images, and a bunch of related
classes, utilities, and applications. Main features include:
- Extremely simple but powerful ImageInput and ImageOutput APIs for reading and
  writing 2D images that is format agnostic.
- Format plugins for TIFF, JPEG/JFIF, OpenEXR, PNG, HDR/RGBE, Targa, JPEG-2000,
  DPX, Cineon, FITS, BMP, ICO, RMan Zfile, Softimage PIC, DDS, SGI,
  PNM/PPM/PGM/PBM, Field3d.
- An ImageCache class that transparently manages a cache so that it can access
  truly vast amounts of image data.

%package -n lib%oname%soname
Summary:        Library for reading and writing images
Group:          System/Libraries

%description -n lib%oname%soname
OpenImageIO is a library for reading and writing images, and a bunch of related
classes, utilities, and applications. Main features include:
- Extremely simple but powerful ImageInput and ImageOutput APIs for reading and
  writing 2D images that is format agnostic.
- Format plugins for TIFF, JPEG/JFIF, OpenEXR, PNG, HDR/RGBE, Targa, JPEG-2000,
  DPX, Cineon, FITS, BMP, ICO, RMan Zfile, Softimage PIC, DDS, SGI,
  PNM/PPM/PGM/PBM, Field3d.
- An ImageCache class that transparently manages a cache so that it can access
  truly vast amounts of image data.

%package -n python3-module-%oname
Summary:        Python-3 bindings for %oname
Group:          Development/Python3
Requires:       lib%oname%soname = %EVR

%description -n python3-module-%oname
Python bindings for %oname.

%package -n %oname-utils
Summary:        Command line utilities for %oname
Group:          Other
Requires:       lib%oname%soname = %EVR
Conflicts:      libxforms-demos

%description -n %oname-utils
Command-line tools to manipulate and get information on images using the
%{name} library.


%package -n %oname-iv
Summary:        %oname based image viewer
Group:          Other
Requires:       lib%oname%soname = %EVR

%description -n %oname-iv
A really nice image viewer, iv, based on %oname classes (and so will work
with any formats for which plugins are available).


%package devel
Summary:        Documentation for %oname
Group:          Development/Other
Requires:       lib%oname%soname = %EVR
Requires:       python3-module-%oname = %EVR
Requires:       %oname-utils = %EVR
Requires:       %oname-iv = %EVR
Requires:       libopencv-devel

%description devel
Development files for package %name


%prep
%setup
%ifarch %e2k
%patch2000 -p1
# simplifies the patch
sed -i '/#if OIIO_SIMD_SSE >= 4/{N;/_mm_dp_ps/s/#if /&!defined(__e2k__) \&\& /}' \
	src/include/OpenImageIO/simd.h
%endif

# Remove bundled pugixml
rm -fr src/include/OpenImageIO/detail/pugixml/

# Install test images
#rm -rf ../oiio-images && mkdir ../oiio-images && pushd ../oiio-images
#tar --strip-components=1 -xzf #{SOURCE1}

%build
%add_optflags -D_FILE_OFFSET_BITS=64

# disable debugging stuff
%add_optflags -DNDEBUG
%ifarch %e2k
%add_optflags -mno-sse4.2 -mno-avx
%endif

# set -DCMAKE_BUILD_TYPE=RelWithDebInfo to skip stripping debuginfo from python modules built via pybind11
%cmake \
	-DINCLUDE_INSTALL_DIR:PATH=%_includedir/%oname \
	-DPYTHON_VERSION=%_python3_version \
	-DINSTALL_DOCS:BOOL=FALSE \
	-DINSTALL_FONTS:BOOL=FALSE \
	-DUSE_EXTERNAL_PUGIXML:BOOL=TRUE \
	-DSTOP_ON_WARNING:BOOL=FALSE \
	-DOPENJPEG_INCLUDE_DIR=$(pkg-config --variable=includedir libopenjp2) \
	-DOpenGL_GL_PREFERENCE=GLVND \
	-DVERBOSE=TRUE \
	-DOIIO_BUILD_TESTS:BOOL=FALSE \
	-DPLUGIN_SEARCH_PATH=%_libdir/OpenImageIO-%soname \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DOIIO_USING_IMATH=3 \
	-DBUILD_DOCS:BOOL=TRUE \
	-DCMAKE_CXX_STANDARD=17 \
	%nil

%cmake_build

%install
%cmake_install

# Move man pages to the right directory
mkdir -p %buildroot%_man1dir
cp -a %_cmake__builddir/src/doc/*.1 %buildroot%_man1dir

mkdir -p %buildroot%_libdir/OpenImageIO-%soname

%files -n lib%oname%soname
%doc CHANGES.md README.md
%doc LICENSE.md THIRD-PARTY.md
%_libdir/libOpenImageIO_Util.so.%{soname}
%_libdir/libOpenImageIO_Util.so.%{soname}.*
%_libdir/OpenImageIO-%soname
%_libdir/libOpenImageIO.so.%{soname}
%_libdir/libOpenImageIO.so.%{soname}.*

%files -n python3-module-%oname
%python3_sitelibdir/OpenImageIO

%files -n %oname-utils
%_bindir/*
%_man1dir/*.1*
%exclude %_bindir/iv
%exclude %_man1dir/iv.1*

%files -n %oname-iv
%_bindir/iv
%_man1dir/iv.1*

%files devel
%_libdir/libOpenImageIO.so
%_libdir/libOpenImageIO_Util.so
%_includedir/*
%_libdir/pkgconfig/OpenImageIO.pc
%_libdir/cmake/*

%changelog
