# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: boost-devel boost-filesystem-devel boost-program_options-devel
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
%define oldname ompl
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%add_optflags %optflags_shared
%define fontpkgname ompl
BuildRequires(pre): rpm-macros-R
%ifnarch %R_exclude_arches
BuildRequires: /usr/bin/R
%endif
ExcludeArch: %R_exclude_arches

%global soversion 17
%global apiversion 1.6

Name:           libompl
Version:        1.6.0
Release:        alt1_7
Summary:        The Open Motion Planning Library

# Automatically converted from old format: BSD - review is highly recommended.
License:        LicenseRef-Callaway-BSD
URL:            http://ompl.kavrakilab.org/
Source0:        https://github.com/%{oldname}/%{oldname}/archive/%{version}/%{oldname}-%{version}.tar.gz
BuildRequires:  gcc-c++
BuildRequires:  boost-complete >= 1.42.0
BuildRequires:  ctest cmake
BuildRequires:  doxygen
BuildRequires:  eigen3
BuildRequires:  libflann-devel
BuildRequires:  graphviz libgraphviz
BuildRequires:  libode-devel

# Move the installed CMake configuration from datadir to libdir.
# Refelects best practice with respect to arch-ful CMake configuration.
# Disable build/installation of plannerarena.
# Not submitted upstream.
Patch0: ompl-1.5.0-cmakeinstall.patch
Source44: import.info
Provides: ompl = %{version}-%{release}

%description
The Open Motion Planning Library (OMPL) consists of many state-of-the-art 
sampling-based motion planning algorithms. OMPL itself does not contain 
any code related to, e.g., collision checking or visualization. This is 
a deliberate design choice, so that OMPL is not tied to a particular 
collision checker or visualization front end.

%package        devel
Group: Development/Other
Summary:        Development files for %{oldname}
Requires:       %{name} = %{version}-%{release}
Requires:       boost-complete
Provides: ompl-devel = %{version}-%{release}
AutoReq: yes,nopython
AutoProv: yes,nopython

%description    devel
The %{oldname}-devel package contains libraries and header files for
developing applications that use %{oldname}.


%prep
%setup -n %{oldname}-%{version} -q
# Get rid of bundled libs
rm -rf src/external/
rm -rf scripts/plannerarena
%patch0  -p0 -b .cmakeinstall

%build
# Python bindings are disabled because dependencies pygccxml and pyplusplus are not packaged for Fedora
%{fedora_v2_cmake}  \
  -DCMAKE_BUILD_TYPE=Release \
  -DCMAKE_SKIP_RPATH=ON \
  -DOMPL_BUILD_PYBINDINGS=OFF \
  -DOMPL_LIB_INSTALL_DIR=%{_lib} \
  -DBOOST_LIBRARYDIR=%{_libdir} \
  -DODE_LIB_PATH=%{_libdir} \
  -DBUILD_OMPL_TESTS=ON  \
  -DOMPL_ODESOLVER=ON \
  -DOMPL_REGISTRATION=OFF

%fedora_v2_cmake_build
%fedora_v2_cmake_build --target ompl_doc
rm -f ompl_doc/installdox

%install
%fedora_v2_cmake_install

rm -f %{buildroot}%{_datadir}/%{oldname}/demos/*.py
rm -rf %{buildroot}%{_includedir}/%{oldname}/CMakeFiles
rm -rf %{buildroot}%{_bindir}
rm -f %{buildroot}%{_mandir}/man1/plannerarena*
rm -f %{buildroot}%{_mandir}/man1/ompl_benchmark_statistics*
rm -rf %{buildroot}%{_datadir}/ament_index

%check
export LD_LIBRARY_PATH=%{buildroot}%{_libdir}
# Test failures can be triggered by builder CPU speed.
# Accept test failures for slow builders.
%fedora_v2_ctest || exit 0


%files
%doc LICENSE README.md
%{_libdir}/libompl.so.%{version}
%{_libdir}/libompl.so.%{soversion}

%files devel
%doc %{_vpath_builddir}/ompl_doc
%{_libdir}/libompl.so
%{_includedir}/%{oldname}-%{apiversion}
%{_datadir}/%{oldname}
%{_libdir}/pkgconfig/*.pc
%{_libdir}/%{oldname}

%changelog
