%define _unpackaged_files_terminate_build 1
%define soname 200

Name: libnl3
Version: 3.11.0
Release: alt1

Summary: library for applications dealing with netlink sockets
License: LGPLv2.1
Group: System/Libraries
Url: https://github.com/thom311/libnl/
BuildRequires: glibc-kernheaders flex
# For tests
BuildRequires: libcheck-devel
BuildRequires: /proc /dev/kvm rpm-build-vm
Requires: libnl-common
Conflicts: libnl3-utils < 3.10.0

VCS: https://github.com/thom311/libnl 
Source: %name-%version.tar

%description
The libnl suite is a collection of libraries providing APIs to netlink protocol
based Linux kernel interfaces.  Netlink is a IPC mechanism primarly between the
kernel and user space processes. It was designed to be a more flexible
successor to ioctl to provide mainly networking related kernel configuration
and monitoring interfaces.

%package -n libnl-devel
Summary: header files for libnl, a netlink sockets library
Group: System/Libraries
Requires: %name = %EVR
Obsoletes: libnl3-devel < %version-%release

%description -n libnl-devel
libnl is a library for applications dealing with netlink sockets.

This package contains header files for libnl.

%package utils
Summary: Command line interface utils for libnl3
Group: System/Base
Provides: libnl-utils = %EVR

%description utils
This package contains various libnl3 utils and additional
libraries on which they depend

%package -n libnl-common
Summary: Common files for %name
Group: System/Libraries
Conflicts: libnl3 < 3.10.0
Conflicts: libnl3-utils < 3.10.0

%description -n libnl-common
This package contains common libnl3 files.


%prep
%setup

%build
%autoreconf
%configure \
	--disable-static \
	--disable-silent-rules
%make

%install
%makeinstall_std

%check
%make check-progs
vm-run make check

%files
%_libdir/libnl*.so.%soname
%_libdir/libnl*.so.%soname.*

%files -n libnl-common
%_libdir/libnl/
%config(noreplace) %_sysconfdir/libnl/

%files -n libnl-devel
%_libdir/libnl*.so
%_includedir/libnl3
%_pkgconfigdir/*.pc

%files utils
%_bindir/*
%_man8dir/*

%changelog
