# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define sover 0
%def_enable ocaml

Name: libnbd
Version: 1.23.9
Release: alt1
Summary: NBD client library in userspace
License: LGPL-2.1-or-later
Group: Networking/File transfer
Url: https://gitlab.com/nbdkit/libnbd

Source: %name-%version.tar
BuildRequires: bash-completion
BuildRequires: gcc-c++
BuildRequires: hardlink
BuildRequires: libfuse3-devel
BuildRequires: libgnutls-devel
%ifnarch %e2k
BuildRequires: libublksrv-devel
%endif
BuildRequires: liburing-devel
BuildRequires: libxml2-devel
BuildRequires: perl-podlators
%if_enabled ocaml
BuildRequires(pre): rpm-build-ocaml
BuildRequires: ocaml
BuildRequires: ocaml-findlib
BuildRequires: ocaml-ocamldoc
%endif

%description
%summary.

%package -n %name%sover
Summary: %name system library
Group: System/Libraries

%description -n %name%sover
%summary.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name%sover = %EVR

%description devel
%summary.

%package -n ocaml-%name
Summary: OCaml language bindings for %name
Group: Development/Other
Provides: ocaml-nbd = %EVR
Requires: %name%sover = %EVR

%description -n ocaml-%name
This package contains OCaml language bindings for %name.

%package -n ocaml-%name-devel
Summary: OCaml language development package for %name
Group: Development/Other
Provides: ocaml-nbd-devel = %EVR
Requires: ocaml-%name = %EVR

%description -n ocaml-%name-devel
This package contains OCaml language development package for
%name. Install this if you want to compile OCaml software which
uses %name.

%prep
%setup

%build
%autoreconf
%configure \
    --disable-static \
    --disable-golang \
    %{subst_enable ocaml} \
    --disable-python \
    %nil
%make_build

%install
%makeinstall_std
hardlink -v %buildroot

# For python script we don't build (yet).
rm %buildroot%_datadir/bash-completion/completions/nbdsh

%check
%make_build check
# qemu-nbd tests require nbdsh built, nbdkit will cause cyclic
# dependence, so be careful.

%files
%_bindir/nbd*
%_man1dir/nbd*.1*
%_datadir/bash-completion/completions/*

%files -n %name%sover
%_libdir/libnbd.so.%sover
%_libdir/libnbd.so.%sover.*

%files devel
%_includedir/libnbd.h
%_libdir/libnbd.so
%_pkgconfigdir/libnbd.pc
%_man1dir/libnbd-*.1*
%_man3dir/*.3*
%exclude %_man3dir/libnbd-ocaml.3*
%exclude %_man3dir/NBD*

%if_enabled ocaml
%files -n ocaml-%name
%_libdir/ocaml/nbd
%exclude %_libdir/ocaml/nbd/*.a
%ifarch %ocaml_native_arch
%exclude %_libdir/ocaml/nbd/*.cmxa
%exclude %_libdir/ocaml/nbd/*.cmx
%endif
%exclude %_libdir/ocaml/nbd/*.mli
%_libdir/ocaml/stublibs/*.so
%_libdir/ocaml/stublibs/*.so.owner

%files -n ocaml-%name-devel
%doc ocaml/examples/*.ml
%_libdir/ocaml/nbd/*.a
%ifarch %ocaml_native_arch
%_libdir/ocaml/nbd/*.cmxa
%_libdir/ocaml/nbd/*.cmx
%endif
%_libdir/ocaml/nbd/*.mli
%_man3dir/libnbd-ocaml.3*
%_man3dir/NBD*
%endif

%changelog
