%define sover 0

%ifnarch i586
%def_enable check
%endif

Name: libmongocrypt
Version: 1.16.0
Release: alt1

Summary: The companion C library for client side encryption in drivers

License: Apache-2.0
Group: System/Libraries
Url: https://github.com/mongodb/libmongocrypt
VCS: https://github.com/mongodb/libmongocrypt

# Source-url: https://github.com/mongodb/libmongocrypt/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: libmongocrypt-1.15.1-fedora-static-libbson.patch
Patch2: libmongocrypt-1.16.0-alt-libbson1.patch

BuildRequires: cmake gcc-c++ git-core libbson-devel libssl-devel python3
%if_enabled check
BuildRequires: ctest
%endif

%description
%summary.

%package common
Summary: The common files for %name
Group: Documentation
BuildArch: noarch

%description common
This package provides the common files for %name.

%package -n libkms_message-common
Summary: The common files for libkms_message
Group: Documentation
BuildArch: noarch

%description -n libkms_message-common
This package provides the common files for libkms_message.

%package -n %name%sover
Summary: The companion C library for client side encryption in drivers
Group: System/Libraries

%description -n %name%sover
This package provides libmongocrypt library.

%package -n libkms_message%sover
Summary: The kms-message C library
Group: System/Libraries

%description -n libkms_message%sover
This package provides libkms_message library.

%package devel
Summary: The development files for %name
Group: Development/C

%description devel
This package provides development files for %name.

%package -n libkms_message-devel
Summary: The development files for libkms_message
Group: Development/C

%description -n libkms_message-devel
This package provides development files for libkms_message.

%prep
%setup
%patch0 -p1
%patch1 -p1
%if "%(rpmquery --qf '%%{VERSION}' libbson-devel)" < "2"
%patch2 -p2
%endif

%build
%cmake \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DBUILD_VERSION=%version \
  -DENABLE_PIC=ON \
  -DUSE_SHARED_LIBBSON=ON \
  -DMONGOCRYPT_MONGOC_DIR=USE-SYSTEM \
  -DENABLE_ONLINE_TESTS=OFF \
  -DENABLE_STATIC=OFF \
#
%ifarch %e2k
sed -i 's/_M_AMD64/__e2k__/' %_cmake__builddir/_deps/intel_dfp-src/LIBRARY/float128/architecture.h
%endif
%cmake_build

%install
%cmake_install

%if_enabled check
%check
cd %_cmake__builddir
ctest
%endif

%files common
%doc CHANGELOG.md LICENSE README.md

%files -n libkms_message-common
%doc kms-message/{COPYING,README.md,THIRD_PARTY_NOTICES}

%files -n %name%sover
%_libdir/libmongocrypt.so.%{sover}*

%files -n libkms_message%sover
%_libdir/libkms_message.so.%{sover}*

%files devel
%_includedir/mongocrypt/
%_libdir/libmongocrypt.so
%_libdir/cmake/mongocrypt/
%_pkgconfigdir/libmongocrypt.pc

%files -n libkms_message-devel
%_includedir/kms_message/
%_libdir/libkms_message.so
%_libdir/cmake/kms_message/
%_pkgconfigdir/libkms_message.pc

%changelog
