%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_disable static

%if_enabled static
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%endif

Name: libmm
Version: 1.4.2
Release: alt4

%define srcname mm-%version

Summary: Shared Memory Abstraction Library
License: BSD-style
Group: System/Libraries

Url: http://www.ossp.org/pkg/lib/mm
Source: %url/%srcname.tar.gz
Packager: Michael Shigorin <mike@altlinux.org>

Provides: mm = %version
Obsoletes: mm < %version

# Automatically added by buildreq on Mon Mar 21 2011
BuildRequires: glibc-devel-static termutils

%package devel
Summary: Development files for Shared Memory Abstraction Library
Group: Development/C
Requires: %name = %EVR
Provides: mm-devel = %version
Obsoletes: mm-devel < %version

%package devel-static
Summary: Static version of Shared Memory Abstraction Library
Group: Development/C
Requires: %name-devel = %EVR

%description
The MM library is a 2-layer abstraction library which simplifies the usage of
shared memory between forked (and this way strongly related) processes under
Unix platforms. On the first layer it hides all platform dependent
implementation details (allocation and locking) when dealing with shared
memory segments and on the second layer it provides a high-level malloc(3)-
style API for a convenient and well known way to work with data-structures
inside those shared memory segments.

%description devel
The MM library is a 2-layer abstraction library which simplifies the usage of
shared memory between forked (and this way strongly related) processes under
Unix platforms. On the first layer it hides all platform dependent
implementation details (allocation and locking) when dealing with shared
memory segments and on the second layer it provides a high-level malloc(3)-
style API for a convenient and well known way to work with data-structures
inside those shared memory segments.

This package contains header files and tools needed for development with %name.

%description devel-static
The MM library is a 2-layer abstraction library which simplifies the usage of
shared memory between forked (and this way strongly related) processes under
Unix platforms. On the first layer it hides all platform dependent
implementation details (allocation and locking) when dealing with shared
memory segments and on the second layer it provides a high-level malloc(3)-
style API for a convenient and well known way to work with data-structures
inside those shared memory segments.

This package contains static library needed for development of statically
linked software with %name.

%prep
%setup -q -n %srcname
bzip2 -k ChangeLog

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%configure \
	--enable-debug \
%if_enabled static
	--enable-static \
%else
	--disable-static \
%endif
	%nil

%make_build
make test

%install
%makeinstall

%files
%_libdir/*.so.*
%doc README LICENSE ChangeLog.bz2 PORTING THANKS

%files devel
%_bindir/*
%_libdir/*.so
#_libdir/*.la
%_includedir/*
%_mandir/man?/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
