%define ver_major 25.09

Name: libmediainfo
Version: %ver_major
Release: alt1

Group: System/Libraries
Summary: %name - Shared library for mediainfo
License: BSD-2-Clause
Url: http://mediainfo.sourceforge.net

Vcs: https://github.com/MediaArea/MediaInfoLib.git

Source: https://mediaarea.net/download/source/%name/%version/%{name}_%{version}.tar.xz

BuildRequires: gcc-c++
BuildRequires: dos2unix
BuildRequires: doxygen graphviz
BuildRequires: zlib-devel
BuildRequires: id3lib-devel
BuildRequires: libflac-devel
BuildRequires: libmatroska-devel
BuildRequires: libfaad-devel
BuildRequires: libzen-devel >= 0.4.41
BuildRequires: libcurl-devel
BuildRequires: libmms-devel
BuildRequires: libtinyxml2-devel

%package devel
Group: System/Libraries
Summary: Devel package for %name
Requires: %name = %version
Provides: %name.so

%description
MediaInfo supplies technical and tag information about a video or audio file.
What information can I get from MediaInfo?
General: title, author, director, album, track number, date, duration...
Video: codec, aspect, fps, bitrate...
Audio: codec, sample rate, channels, language, bitrate...
Text: language of subtitle
Chapters: number of chapters, list of chapters

What format (container) does MediaInfo support?
Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2,
       MPEG-4, DVD (VOB)...
(Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
Subtitles: SRT, SSA, ASS, SAMI...

This package includes the shared library

%description devel
This package includes the development support files of the libmediainfo

%prep
%setup -q -T -b 0 -n MediaInfoLib
dos2unix ReadMe.txt Project/GNU/Library/%name.pc.in
%ifarch %e2k
# error: invalid narrowing conversion from "style" to "int8u"
sed -i 's/ = (style)-1/ = (int8u)-1/' Source/MediaInfo/Audio/File_Adm.cpp
%endif

%build
pushd Source/Doc
doxygen Doxyfile
popd
pushd Project/GNU/Library
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --enable-shared=yes \
    --enable-static=no \
    --disable-staticlibs \
    --with-libcurl=system \
    --with-libmms=system \
    --with-libtinyxml2=system
%make_build
popd

%install
pushd Project/GNU/Library
%makeinstall_std
popd

%files
%_libdir/%name.so.*
%doc ReadMe.txt README* Changes.txt History_DLL.txt

%files devel
%_includedir/MediaInfo/
%_includedir/MediaInfoDLL/
%_pkgconfigdir/%name.pc
%_libdir/%name.so

%changelog
