%define srcName leptonlib

Name: libleptonica
Version: 1.83.1
Release: alt1

Summary: A library for manipulating images
Summary(ru_RU.UTF-8): Библиотека для операций над изображениями

License: BSD-2-Clause
Group: System/Libraries
Url: http://www.leptonica.com

# Source-url: https://github.com/DanBloomberg/leptonica/releases/download/%version/leptonica-%version.tar.gz
Source: leptonlib-%version.tar.bz2

Patch: %name-1.69-alt-debuginfo.patch
Patch1: %name-alt-makefile.patch

BuildRequires: doxygen
BuildRequires: libjpeg-devel
BuildRequires: libtiff-devel
BuildRequires: libpng-devel
BuildRequires: libgif-devel
BuildRequires: libwebp-devel
BuildRequires: libopenjpeg2.0-devel

%package devel
Summary: Development files for programs which will use the Leptonica library
Summary(ru_RU.UTF-8): Заголовочные файлы для программ, использующих библиотеку Leptonica
Group: Development/C
Requires: %name = %version-%release glibc-devel libcurl-devel libssl-devel zlib-devel libjpeg-devel libtiff-devel libpng-devel

%package devel-static
Summary: Static Leptonica library
Summary(ru_RU.UTF-8): Версия библиотеки Leptonica для статического связывания
Group: Development/C
Requires: %name-devel = %version-%release

%package doc
Summary: Documentation prepared with Doxygen
Group: Development/C
Requires: %name-devel = %version-%release
BuildArch: noarch

%description
This package contains a Leptonica shared library of functions for loading,
manipulating and saving image files.

%description -l ru_RU.UTF-8
Библиотека Leptonica предназначена для создания программ, обрабатывающих
цветные и чёрно-белые изображения. Она содержит большое количество
низкоуровневых процедур обработки изображений. В частности, процедуры,
осуществляющие изменение контрастности, яркости, построение гистограмм,
различные морфологические процедуры. Библиотека написана на языке C.
Обязательно следует отметить, что новые версии библиотеки выходят довольно часто,
примерно раз в месяц, и не всегда полностью совместимы друг с другом.

%description devel
This package includes development files necessary for developing programs
which use Leptonica library

%description -l ru_RU.UTF-8 devel
Этот пакет содержит заголовочные файлы для библиотеки Leptonica -
библиотеки, предназначенной для создания программ, обрабатывающих изображения.

%description devel-static
This package includes static library necessary for developing statically
which use Leptonica library

%description -l ru_RU.UTF-8 devel-static
Этот пакет содержит версию библиотеки Leptonica для статического связывания.
Использование статической версии библиотеки зачастую оправдано, поскольку
обратная совместимость между версиями библиотеки не сохраняется, а
новые выпуски появляются примерно раз в месяц.

%description doc
This package includes Leptonica library documentation prepared with Doxygen.
The documentation is in html format.

%description -l ru_RU.UTF-8 doc
В этом пакете содержится автоматически сгенерированная с помощью пакета
Doxygen документация в html формате по функциям библиотеки Leptonica. Все функции библиотеки,
которые можно использовать из программ, имеют краткое описание и определение
параметров. Другой документации, к сожалению, не существует.
Файлы с описаниями библиотеки расположены в каталоге
%_docdir/libleptonica-xxx/html

%prep
%setup -n %srcName-%version
%autopatch -p1

%build
# Packaging static libraries lto * .a
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%autoreconf
%configure
%make_build

doxygen Doxyfile

%install
%makeinstall_std
# link to a non-existent file
rm -f %buildroot%_libdir/*.la

%files
%doc README.html
%doc version-notes.html
%doc leptonica-license.txt
%_libdir/*.so.*
# utilities for working with files
# without them, the work with the program will be incomplete
%_bindir/*

%files devel
%_includedir/leptonica
%_libdir/libleptonica.so
%_pkgconfigdir/lept.pc
%_libdir/cmake/LeptonicaConfig-version.cmake
%_libdir/cmake/LeptonicaConfig.cmake

%files devel-static
%_libdir/*.a

%files doc
%doc doc/html/*

%changelog
