%def_without gui

Name: libkate
Version: 0.4.3
Release: alt1
Summary: kate is a karaoke and text codec for embedding in ogg
License: BSD-3-Clause
Group: Video
URL: https://gitlab.xiph.org/xiph/kate

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: flex libogg-devel liboggz libpng-devel

%description
Kate is a codec for karaoke and text encapsulation for Ogg. Most of the time,
this would be multiplexed with audio/video to carry subtitles, song lyrics
(with or without karaoke data), etc, but doesn't have to be. A possible use
of a lone Kate stream would be an e-book. Moreover, the motion feature gives
Kate a powerful means to describe arbitrary curves, so hand drawing of shapes
can be achieved. This was originally meant for karaoke use, but can be used
for any purpose. Motions can be attached to various semantics, like position,
color, etc, so scrolling or fading text can be defined.

%package devel
Summary: %name Library and Header Files
Group: Development/C

%description devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name.

%package utils
Summary: Kate codec utilities
Group: Video
Requires: %name = %version-%release

%description utils
Basic utilities for encoding, decoding and manipulating subtitles.

%package -n KateDJ
Summary: simple UI for kate
Group: Video
Requires: %name-utils = %version-%release liboggz
BuildArch: noarch

%description -n KateDJ
KateDJ is a simple UI driven program that can extract Kate
streams from Ogg files, and merge them back in. It can be
used to make alterations to Kate streams easily, or to add
new Kate streams to an Ogg file.

%prep
%setup -q
%patch -p1
subst 's|#!.*python$|#!%__python3|' tools/KateDJ/KateDJ

%build
export PYTHON=%__python3
%autoreconf
%configure \
	--disable-static
%make

%install
export PYTHON=%__python3
%make DESTDIR=%buildroot pythondir=%python3_sitelibdir_noarch install
rm -rf %buildroot%_datadir/doc/libkate

%files
%doc AUTHORS THANKS
%_libdir/*.so.*

%files devel
%_includedir/kate
%_libdir/*.so
%_pkgconfigdir/*.pc

%files utils
%doc README
%_bindir/kat*
%_man1dir/kat*.1*

%if_with gui
%files -n KateDJ
%_bindir/KateDJ
%python_sitelibdir_noarch/kdj
%_man1dir/KateDJ.1*
%endif

%changelog
