%def_disable snapshot
%define api_ver 1.0

%def_disable python
%def_enable check

Name: libimobiledevice
Version: 1.4.0
Release: alt1

Summary: Library for connecting to Apple iPhone and iPod touch
Group: System/Libraries
License: GPL-2.0 and LGPL-2.1
Url: http://www.libimobiledevice.org

Vcs: https://github.com/libimobiledevice/libimobiledevice.git

%if_disabled snapshot
Source: https://github.com/libimobiledevice/libimobiledevice/releases/download/%version/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

%define plist_ver 2.7.0
%define glue_ver 1.3.2
%define usbmuxd_ver 2.0.2
%define tatsu_ver 1.0.3
%define cython_ver 3.0.0

BuildRequires: libplist-devel >= %plist_ver
BuildRequires: libusbmuxd-devel >= %usbmuxd_ver
BuildRequires: pkgconfig(libimobiledevice-glue-1.0) >= %glue_ver
BuildRequires: pkgconfig(libtatsu-1.0) >= %tatsu_ver

BuildRequires: gcc-c++ autoconf-archive glib2-devel libxml2-devel libusb-devel libplistmm-devel
BuildRequires: libgnutls-devel libtasn1-devel libgcrypt-devel libssl-devel
%{?_enable_python:BuildRequires: python3-devel python3-module-Cython >= %cython_ver python3-module-libplist}

%description
libimobiledevice is a library for connecting to Apple's iPhone or iPod touch devices

%package devel
Summary: Development package for libimobiledevice
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides files for development using libimobiledevice.

%package -n python3-module-%name
Summary: Python bindings for libimobiledevice
Group: Development/Python3
Requires: %name = %version-%release

%description -n python3-module-%name
Python bindings for libimobiledevice.

%prep
%setup
echo %version > .tarball-version

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static \
    %{?_disable_python:--without-cython} \
    %{?_enable_python:PYTHON=%__python3}
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/idevice*
%_bindir/afcclient
%_libdir/%name-%api_ver.so.*
%_man1dir/*
%doc AUTHORS NEWS README*

%files devel
%_includedir/%name
%_libdir/%name-%api_ver.so
%_pkgconfigdir/*.pc

%if_enabled python
%files -n python3-module-%name
%python3_sitelibdir/imobiledevice.so
%exclude %python_sitelibdir/imobiledevice.la
%endif

%changelog
