# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major 2
%define libname libilbc%{major}
%define libnamedev libilbc-devel

Summary:	Internet Low Bitrate Codec (iLBC) library
Name:		libilbc
Epoch:		1
Version:	2.0.2
Release:	alt1_8.2
License:	BSD-style
Group:		System/Libraries
URL:		https://github.com/TimothyGu/libilbc
Source0:	https://github.com/TimothyGu/libilbc/releases/download/v%{version}/libilbc-%{version}.tar.gz
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	libtool
Source44: import.info
Patch33: libilbc-2.0.2-added-mipseb-and-ppc64le.patch

%description
iLBC (internet Low Bitrate Codec) is a FREE speech codec suitable for robust
voice communication over IP. The codec is designed for narrow band speech and
results in a payload bit rate of 13.33 kbit/s with an encoding frame length of
30 ms and 15.20 kbps with an encoding length of 20 ms. The iLBC codec enables
graceful speech quality degradation in the case of lost frames, which occurs in
connection with lost or delayed IP packets.

%package -n	%{libname}
Summary:	Internet Low Bitrate Codec (iLBC) library
Group:          System/Libraries

%description -n	%{libname}
iLBC (internet Low Bitrate Codec) is a FREE speech codec suitable for robust
voice communication over IP. The codec is designed for narrow band speech and
results in a payload bit rate of 13.33 kbit/s with an encoding frame length of
30 ms and 15.20 kbps with an encoding length of 20 ms. The iLBC codec enables
graceful speech quality degradation in the case of lost frames, which occurs in
connection with lost or delayed IP packets.

%package -n %{libnamedev}
Summary:	Development and header files for the iLBC library
Group:		Development/C
Requires:	%{libname} = %{epoch}:%{version}-%{release}
#Provides:	ilbc-devel = %{epoch}:%{version}-%{release}
#Provides:	%{name}-devel = %{epoch}:%{version}-%{release}
#Conflicts:	libilbc2-devel < 1.0.0

%description -n %{libnamedev}
iLBC (internet Low Bitrate Codec) is a FREE speech codec suitable for robust
voice communication over IP. The codec is designed for narrow band speech and
results in a payload bit rate of 13.33 kbit/s with an encoding frame length of
30 ms and 15.20 kbps with an encoding length of 20 ms. The iLBC codec enables
graceful speech quality degradation in the case of lost frames, which occurs in
connection with lost or delayed IP packets.

%prep

%setup -q -n libilbc-%{version}
%ifarch %e2k
sed -i "s/__aarch64__/__e2k__/" typedefs.h
%else
%patch33 -p1
%endif

%build
autoreconf -fi
%configure \
    --disable-static
%make_build

%install
%makeinstall_std

# symlinks for compatibility
ln -s ilbc.h %{buildroot}%{_includedir}/iLBC_decode.h
ln -s ilbc.h %{buildroot}%{_includedir}/iLBC_define.h
ln -s ilbc.h %{buildroot}%{_includedir}/iLBC_encode.h

# we don't want these
rm -f %{buildroot}%{_libdir}/*.*a
rm -rf %{buildroot}%{_datadir}/doc/libilbc

%files -n %{libname}
%doc COPYING README* NEWS*
%{_libdir}/libilbc.so.%{major}*

%files -n %{libnamedev}
%{_includedir}/*.h
%{_libdir}/libilbc.so
%{_libdir}/pkgconfig/libilbc.pc


%changelog
