%def_disable snapshot

%define _name harfbuzz
%define ver_major 12.1
%define namespace HarfBuzz
%define api_ver 0.0

%def_enable graphite2
%def_enable icu
%def_enable cairo
%def_enable gobject
%def_enable introspection
%def_enable docs
%def_disable experimental_api

%ifnarch armh
%def_enable check
%endif

Name: lib%_name
Version: %ver_major.0
Release: alt1

Summary: HarfBuzz is an OpenType text shaping engine
Group: System/Libraries
License: MIT
Url: https://harfbuzz.org/

Vcs: https://github.com/harfbuzz/harfbuzz.git

%if_disabled snapshot
Source: https://github.com/%_name/%_name/archive/%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.30.0
%define cairo_ver 1.10.0
%define icu_ver 49.0
%define graphite2_ver 1.2.0
%define freetype_ver 12.0.6

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson gcc-c++ glib2-devel >= %glib_ver
BuildRequires: pkgconfig(freetype2) >= %freetype_ver libcairo-devel >= %cairo_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_graphite2:BuildRequires: libgraphite2-devel >= %graphite2_ver}
%{?_enable_icu:BuildRequires: pkgconfig(icu-uc) >= %icu_ver}
%{?_enable_docs:BuildRequires: gtk-doc help2man}
%{?_enable_check:BuildRequires: python3-test fonttools}

%description
HarfBuzz is an implementation of the OpenType Layout engine.
This package provides shared HarfBuzz library.

%package icu
Summary: Shared HarfBuzz library with ICU support.
Group: System/Libraries
Requires: %name = %EVR

%description icu
HarfBuzz is an implementation of the OpenType Layout engine.
This package provides shared HarfBuzz library with ICU support.

%package cairo
Summary: Shared HarfBuzz library with Cairo support.
Group: System/Libraries
Requires: %name = %EVR

%description cairo
HarfBuzz is an implementation of the OpenType Layout engine.
This package provides shared HarfBuzz library with Cairo support.

%package gobject
Summary: GObject bindings for %name
Group: System/Libraries
Requires: %name = %EVR

%description gobject
This package contains functionality to make HarfBuzz library
integrate well with the GObject object system used by GNOME.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR
%{?_enable_icu:Requires: %name-icu = %EVR}
%{?_enable_cairo:Requires: %name-cairo = %EVR}
%{?_enable_gobject:Requires: %name-gobject = %EVR}

%description devel
The %name-devel package contains files for developing applications that
use HarfBuzz library.


%package devel-doc
Summary: Development documentation for Pango
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
HarfBuzz is an implementation of the OpenType Layout engine.
This package contains development documentation for HarfBuzz.

%package utils
Summary: Utilities from HarfBuzz project
Group: Development/Tools
Requires: %name = %EVR

%description utils
The %name-utils package provides utilities from %name package.

%package gir
Summary: GObject introspection data for the HarfBuzz library
Group: System/Libraries
Requires: %name-gobject = %EVR

%description gir
GObject introspection data for the HarfBuzz library

%package gir-devel
Summary: GObject introspection devel data for the HarfBuzz library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the HarfBuzz library

%prep
%setup -n %_name-%version

%build
%meson \
    -Dglib=enabled \
    -Dfreetype=enabled \
    %{subst_enable_meson_feature icu icu} \
    %{subst_enable_meson_feature cairo cairo} \
    %{subst_enable_meson_feature graphite2 graphite2} \
    %{subst_enable_meson_feature gobject gobject} \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_feature docs docs} \
    %{subst_enable_meson_bool experimental_api experimental_api}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test -t 4

%files
%_libdir/%name.so.*
%_libdir/%name-subset.so.*

%if_enabled icu
%files icu
%_libdir/%name-icu.so.*
%endif

%if_enabled cairo
%files cairo
%_libdir/%name-cairo.so.*
%endif

%if_enabled gobject
%files gobject
%_libdir/%name-gobject.so.*
%endif

%files devel
%_includedir/%_name/
%_libdir/%name.so
%_libdir/%name-subset.so
%_pkgconfigdir/%_name.pc
%_pkgconfigdir/%_name-subset.pc
%{?_enable_icu:
%_libdir/%name-icu.so
%_pkgconfigdir/%_name-icu.pc}
%{?_enable_cairo:
%_libdir/%name-cairo.so
%_pkgconfigdir/%_name-cairo.pc}
%_libdir/cmake/%_name/
%doc NEWS AUTHORS COPYING README.md
%if_enabled gobject
%_libdir/%name-gobject.so
%_pkgconfigdir/%_name-gobject.pc
%endif

%if_enabled docs
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%files utils
%_bindir/hb-info
%_bindir/hb-view
%_bindir/hb-shape
%_bindir/hb-subset
%_man1dir/hb-*

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%changelog
